<?php

namespace App\Exports;

use App\Models\UserPeriod;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithHeadings;

class MalistExport implements FromCollection, WithHeadings
{
    use Exportable;

    protected int $year;

    public function __construct(int $year)
    {
        $this->year = $year;
    }

    public function headings(): array
    {
        return [
            'Periode',
            'OAV nummer',
            'Bedrijfsnaam',
            'Plaatsnaam',
            'Heeft u deze periode iets aan te geven?',
            'Productie in Nederland m2',
            'Import uit België m2',
            'Import uit Duitsland m2',
            'Import uit Polen m2',
            'Import uit Turkije m2',
            'Import overig m2',
            'Totaal aantal gefactureerde m2 isolatieglas',
            'Gewicht in kg (optioneel)',
            'Recyclingbijdrage per m2',
            'Bijdrage excl. BTW in Euro',
            'BTW 21%',
            'Bijdrage inclusief BTW in Euro'
        ];
    }

    public function collection()
    {
        return UserPeriod::query()
            ->select(
                'periods.period',
                'users.oav_number AS oav_nummer',
                'users.company_name AS bedrijfsnaam',
                'users.place AS plaatsnaam',
                DB::raw("IF(declarations.status = 1, 'Ja', 'Nee') AS status"),
                'declarations.pro_nl',
                'declarations.imp_be',
                'declarations.imp_de',
                'declarations.imp_po',
                'declarations.imp_turk',
                'declarations.import',
                'declarations.total_m2',
                'declarations.weight',
                'declarations.unit_price',
                'declarations.total',
                'declarations.btw',
                'declarations.total_btw'
            )
            ->join('periods', 'periods.id', '=', 'user_periods.period_id')
            ->join('users', 'users.id', '=', 'user_periods.user_id')
            ->leftJoin('declarations', 'declarations.user_period_id', '=', 'user_periods.id')
            ->where('periods.group_period', $this->year)
            ->orderBy('periods.position')
            ->get();
    }
}
