<?php

namespace App\Http\Controllers\Admin;


use App\Http\Controllers\Controller;
use App\Imports\UsersImport;
use App\Jobs\AssignPeriod;
use App\Mail\CreateAdmin;
use App\Mail\CreateUser;
use App\Models\Admin;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use App\Models\User;
use Excel;

class AdminController extends Controller
{
    public function index(){
        $owner = Auth::guard('admin')->user();
        $admin = new Admin();
        $list = $admin->getListAdmin();
        $listRole = [
            8 => 'sub Admin',
            9 => 'Admin'
        ];
        $params = [
            'owner' => $owner,
            'list' => $list,
            'listRole' => $listRole
        ];

        return view('admin.admin.index', $params);
    }

    public function update($id = 0){

        // $admin = Admin::where('email','support@guifiontwikkelt.nl')->first();
        // $admin->password = Hash::make('FoxH4yHvdz');
        // $admin->save();
        // echo '<pre>';
        // print_r($admin);
        // die();
        if(!empty($id)){
            abort(404);
        } else {
            $admin = new Admin();
        }

        $params = [
            'admin' => $admin
        ];

        return view('admin.admin.update', $params);
    }

    public function store(Request $request){
        $data = $request->all();
        $validator = Validator::make($data, [
            'email' => 'required|email',
            'id' => 'required'
        ]);

        if($validator->fails()){
            return redirect(route('admin.admin.update', ['id' => $data['id']]))
                ->withErrors($validator->errors())
                ->withInput();
        } else {
            if(empty($data['id'])){
                $admin = new Admin();
                $password = Str::random(8);
            } else {
                $admin = Admin::where('id', $data['id'])->firstOrFail();
            }
            $admin->user_name = !empty($data['user_name']) ? $data['user_name'] : null;
            $admin->email = !empty($data['email']) ? $data['email'] : null;
            if(!empty($password)){
                $admin->password = Hash::make($password);
            }
            $admin->active =1;
            $admin->role = 9;
            $admin->save();

            if(empty($data['id'])){
                Mail::to($data['email'])->queue(new CreateAdmin($password));
            }

            return redirect()->route('admin.admin.index');
        }
    }

    public function delete(Request $request){
        $data = $request->all();
        if(!empty($data['id'])){
            $admin = Admin::where('id', $data['id'])->first();
            if(!empty($admin->id)){
                $admin->active = 0;
                $admin->save();
            }
        }

        return response()->json([
           'status' => 'success'
        ]);
    }

    public function importUser(Request $request){
        $extension = $request->file('file')->getClientOriginalExtension();
        $filename = uniqid().'.'.$extension;
        Storage::disk('local')->putFileAs('/files/', $request->file('file'), $filename);
        $path = storage_path('app/files/'.$filename);
        Excel::import(new UsersImport(), $path);

        User::whereRaw('user_name is Null')->delete();
        AssignPeriod::dispatch();

        return response()->json([
            'status' => 'success'
        ]);
    }
}
