<?php


namespace App\Http\Controllers\Admin;


use App\Http\Controllers\Controller;
use App\Mail\CreateUser;
use App\Models\Period;
use App\Models\User;
use App\Models\UserPeriod;
use App\Models\UserUpdate;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use App\Models\RecyclingContribution;

class HomeController extends Controller
{
    public function index(){
        $user = new User();
        $list = $user->getUserActive();

        $params = [
            'list' => $list
        ];
        return view('admin.home.index', $params);
    }

    public function detail($id){
        if(empty($id)){
            $user = new User();
        } else {
            $user = User::where('id', $id)->firstOrFail();
        }

        $recycling_contribution = RecyclingContribution::where('user_id',$user->id)->first();

        $params = [
            'user' => $user,
            'recycling_contribution' => $recycling_contribution,
        ];

        return view("admin.home.detail", $params);
    }

    public function requestEdit(){
        $user = new User();
        $list = $user->getRequestEditUser();

        $params = [
            'list' => $list
        ];

        return view("admin.home.request-edit", $params);
    }

    public function viewRequest($id){
        $userUpdate = UserUpdate::where('user_id', $id)
            ->where('status', UserUpdate::STATUS_PENDING)
            ->firstOrFail();

        $user = User::where('id', $id)->firstOrFail();

        $params = [
            'user' => $user,
            'userUpdate' => $userUpdate
        ];

        return view('admin.home.request', $params);
    }

    public function store(Request $request){
        $data = $request->all();


        $validator = Validator::make($data, [
            'email' => 'email|required',
            /* 'user_name' => 'required', */
            'oav_number' => 'required'
        ]);

		$password 		= ( isset( $data['password'] ) ) ? $data['password'] : '';
		$re_password 	= ( isset( $data['re_password'] ) ) ? $data['re_password'] : '';

		if( $password ){
			if( $password != $re_password || strlen($password) < 10){
				$validator->errors()->add('password', 'Wachtwoord komt niet overeen');
				return redirect(route('admin.home.detail', ['id' => $data['id']]))
                ->withErrors($validator->errors())
                ->withInput();
			}
		}

        if($validator->fails()){
            return redirect(route('admin.home.detail', ['id' => $data['id']]))
                ->withErrors($validator->errors())
                ->withInput();
        } else {
            if(empty($data['id'])){
                $user = new User();
                //$password = Str::random(8);
            } else {
                //$password = '';
                $user = User::where('id', $data['id'])->firstOrFail();
            }



            /* $user->user_name = empty($data['id']) ? $data['user_name'] : $user->user_name; */
            $user->oav_number = empty($data['id']) ? $data['oav_number'] : $user->oav_number;
            $user->email = empty($data['email']) ? null : $data['email'];

            $user->company_name = empty($data['company_name']) ? null : $data['company_name'];
            $user->address = empty($data['address']) ? null : $data['address'];
            $user->postcode = empty($data['postcode']) ? null : $data['postcode'];
            $user->place = empty($data['place']) ? null : $data['place'];
            $user->land = empty($data['land']) ? null : $data['land'];
            $user->phone = empty($data['phone']) ? null : $data['phone'];
            $user->fax = empty($data['fax']) ? null : $data['fax'];
            $user->kvk_number = empty($data['kvk_number']) ? null : $data['kvk_number'];
            $user->btw_number = empty($data['btw_number']) ? null : $data['btw_number'];
			$user->contact_persoon = empty($data['contact_persoon']) ? null : $data['contact_persoon'];
            /*$user->declaration_type = empty($data['declaration_type']) ? null : $data['declaration_type'];
            $user->declaration_web = empty($data['declaration_web']) ? null : $data['declaration_web'];
            $user->contact = empty($data['contact']) ? null : $data['contact'];
            $user->oav_date = empty($data['oav_date']) ? null : $data['oav_date'];*/

			if( $password ){
				$user->password = Hash::make($password);
			}

            $user->save();

            if(!empty($data['mode'])){
                UserUpdate::where('user_id', $user->id)
                    ->where('status', UserUpdate::STATUS_PENDING)
                    ->update([
                        'status' => UserUpdate::STATUS_ACCEPTED
                    ]);
            }

            if(empty($data['id'])){
                $group = date('Y');
                $periods = Period::where('group_period', $group)->get();
                $insert = [];
                foreach ($periods as $period){
                    $insert[] = [
                        'user_id' => $user->id,
                        'period_id' => $period->id
                    ];
                }
                if(!empty($insert)){
                    UserPeriod::insert($insert);
                }
                Mail::to($data['email'])->queue(new CreateUser($user->user_name, $password));
            }

			return redirect(route('admin.home.detail', ['id' => $user->id]))
                ->with(['a_u_message' => 'Opgeslagen']);

            return redirect(route('admin.home.requestEdit'))
                ->with(['a_u_message' => 'gebruiker is bijgewerkt!']);
        }
    }

    public function ajaxGetUser(Request $request){
        $search = $request->get('q');

        $query = User::whereRaw("
                oav_number like ?
            ", ["%$search%"]);

        $items = $query->selectRaw("
                    id,
                    CONCAT(oav_number, ' ==> ', user_name) as text
                ")
            ->paginate(20);

        return response()->json($items);
    }

    public function changeActive(Request $request){
        $data = $request->all();
        $validator = Validator::make($data,[
            'id' => 'required',
            'status' => 'required'
        ]);

        if($validator->fails()){
            return response()->json([
                'status' => 'fail'
            ]);
        } else {
            User::where('id', $data['id'])
                ->update([
                    'active' => $data['status']
                ]);

            return response()->json([
                'status' => 'success'
            ]);
        }
    }
}
