<?php


namespace App\Http\Controllers\Admin;


use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

class LoginAsController extends Controller
{
    public function index(){

        return view('admin.login.index');
    }

    public function loginAction(Request $request){
        $owner = Auth::guard('admin')->user();
        $id = $request->get('id');
        $user = User::where('id', $id)->firstOrFail();
        $code = Str::random(20);
        $codeReturn = Str::random(20);
        $owner->code = $code;
        $owner->user_id = $user->id;
        $owner->code_back = $codeReturn;
        $owner->save();

        Auth::guard('admin')->logout();

        return redirect(route('login.transfer', ['code' => $code]));
    }

    public function backAdmin($code){
        session()->forget('fromAdmin');
        Auth::logout();
        return redirect(route('login.transferAd', ['code' => $code]));
    }

    public function transfer($code){
        $admin = Admin::where('code', $code)->firstOrFail();
        $user = User::where('id', $admin->user_id)->firstOrFail();
        $admin->code = null;
        $admin->save();
        Auth::login($user);

        session()->put('fromAdmin', $admin->code_back);

        return redirect(route('home.index'));
    }

    public function transferAd($code){
        $admin = Admin::where('code_back', $code)->firstOrFail();
        $admin->code_back = null;
        $admin->save();
        Auth::guard('admin')->login($admin);

        return redirect(route('admin.login.index'));
    }
}
