<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\RecyclingContribution;

class RecyclingContributionController extends Controller
{
    public function index(){
        $items = RecyclingContribution::orderBy('id','DESC')->get();
        $params = [
            'items' => $items
        ];
        return view("admin.recycling_contributions.index", $params);
    }

    public function download($id = 0){

        $user_id = $id;
        $outputPath = public_path('storage/recycling_contributions/downloads/recycling-contributions-'.$user_id.'.docx');
        if (file_exists($outputPath)) {
            return response()->download($outputPath);
        }else{
            return redirect()->route('admin.recycling_contributions.index');
        }
    }
}
