<?php

namespace App\Http\Controllers;

use App\Helper\AppConstant;
use App\Mail\ContactAdminMail;
use App\Mail\CreateAdmin;
use App\Mail\NotiAdmin;
use App\Models\ContactAdmin;
use App\Models\Declaration;
use App\Models\DeclarationType;
use App\Models\DeclarationTemp;
use App\Models\Menu;
use App\Models\Period;
use App\Models\UserPeriod;
use App\Models\UserUpdate;
use App\Models\Categories;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use App\Mail\DeclarationAdmin;
use App\Mail\DeclarationCustomer;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use PDF;
use NumNum;
use App\Models\RecyclingContribution;

class HomeController extends Controller
{
    private $schema = 'http://docs.oasis-open.org/ubl/os-UBL-2.2/xsd/maindoc/UBL-Invoice-2.2.xsd';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
        View::share('menu', Menu::all());
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $user = Auth::user();
        $modelDeclarationTemp = new DeclarationTemp();
        $dataDeclare = $modelDeclarationTemp->checkDeclarationTempOfUser($user->id);
        $hasDeclare = false;
        $user = Auth::user();
        $userPeriod = new UserPeriod();
        $listPending = $userPeriod->getListUnfill($user->id);
        $listType = AppConstant::getListPeriodType();
        $listOfCreditMemos = $userPeriod->getListCreditMemos($user->id, 0);
        $recycling_contribution = RecyclingContribution::where('user_id', $user->id)->first();

        if (count($dataDeclare) > 0) {
            $hasDeclare = true;
        }
        $params = [
            'user' => $user,
            'has_declare' => $hasDeclare,
            'listPending' => $listPending,
            'listType' => $listType,
            'listOfCreditMemos' => $listOfCreditMemos,
            'recycling_contribution' => $recycling_contribution,
        ];
        return view('front.index', $params);
    }

    public function bg()
    {
        return view('front.bg');
    }

    public function qa()
    {
        $qa = Menu::where('name', 'qa')->firstOrFail();
        $params = [
            'qa' => $qa
        ];

        return view('front.qa', $params);
    }

    public function ma()
    {
        $user = Auth::user();

        $userPeriod = new UserPeriod();
        $listCertification = $userPeriod->getCertificationList($user->id);
        $list = $userPeriod->getListFilled($user->id, 'period');
        $listPending = $userPeriod->getListUnfill($user->id);
        $listNonInvoice = $userPeriod->getListNoninvoice($user->id);
        $listOfCreditMemo = $userPeriod->getListCreditMemo($user->id);
        $listType = AppConstant::getListPeriodType();

        $params = [
            'user' => $user,
            'list' => $list,
            'listPending' => $listPending,
            'listNon' => $listNonInvoice,
            'listType' => $listType,
            'listCert' => $listCertification,
            'listOfCreditMemo' => $listOfCreditMemo
        ];

        return view('front.ma', $params);
    }

    public function contact()
    {
        $user = Auth::user();
        $listContactType = AppConstant::getListContactType();
        $params = [
            'user' => $user,
            'listContactType' => $listContactType
        ];

        return view('front.contact', $params);
    }

    public function postContact(Request $request)
    {
        $data = $request->all();

        $validator = Validator::make($data, [
            'company_name' => 'required',
            'email' => 'required|email',
            'phone' => 'required'
        ]);

        if ($validator->fails()) {
            return redirect(route('home.contact'))->withErrors($validator->errors())
                ->withInput($data);
        } else {
            $contact = new ContactAdmin();
            $contact->email = $data['email'];
            $contact->company_name = $data['company_name'];
            $contact->phone = $data['phone'];
            if (!empty($data['description'])) {
                $patterns = [
                    '/@php/i',
                    '/{{/',
                    '/{!!/',
                    '/\<\?php/i'
                ];
                $replacements = ['', '', '', ''];

                $data['description'] = trim(preg_replace($patterns, $replacements, $data['description']));
            }
            $contact->description = !empty($data['description']) ? $data['description'] : null;
            $contact->save();
            Mail::to(AppConstant::getAdminEmail())->send(new ContactAdminMail($contact));
            return redirect(route('home.contact'))->with(['b_message' => 'Uw verzoek is verzonden.']);
        }
    }

    public function mg()
    {
        $user = Auth::user();
        $params = [
            'user' => $user
        ];

        return view('front.mg', $params);
    }

    /**
     * Function get List Product to make declaration for user who was assgined by admin
     *
     * @param [type] $id
     * @return void
     */
    public function cma($id)
    {

        $user = Auth::user();

        $userPeriod = new UserPeriod();

        $year = $userPeriod->getYearOfPeriod($id);
        if ($year < 2022) {
            $listType = DeclarationType::where('is_deleted', AppConstant::NOT_DELETED)
                ->where('old_sort', '>=', 1)
                ->orderBy('old_sort', 'asc')->get();
        } else {
            $listType = DeclarationType::where('is_deleted', AppConstant::NOT_DELETED)
                ->where('sort', '>=', 1)
                ->orderBy('sort', 'asc')->get(); // phmd
        }
        if ($year >= 2025) {
            //triple isolatieglas, dubbel isolatieglas, 
            $listType = DeclarationType::where('is_deleted', AppConstant::NOT_DELETED)
                ->whereIn('id', [14, 12, 13])
                ->orderBy('sort', 'asc')->get(); // phmd
        }

        $declarationModel = new Declaration();
        $dec = $declarationModel->getListDeclaration($id);
        $categoryModel = new Categories();
        $listCategories = $categoryModel->getAllCategories();


        //$dec_ok = $userPeriod->getDetailForAdmin($id);
        $unfill = $userPeriod->getListUnfill($user->id);
        $allow_up_ids = [];
        foreach ($unfill as $unfill_item) {
            $allow_up_ids[] = $unfill_item->dec_id;
        }
        if (!in_array($id, $allow_up_ids)) {
            /* if submited already, redirect to home */
            return redirect()->route('home.index');
        }

        $electronischafval = Auth::user()->electronischafval;
        $glasafval = Auth::user()->glasafval;
        foreach ($listCategories as $key => $cat) {
            if ($electronischafval != 1) {
                if ($cat->title == 'Electronisch afval') {
                    unset($listCategories[$key]);
                }
            }
            if ($glasafval != 1) {
                if ($cat->title == 'Glas') {
                    unset($listCategories[$key]);
                }
            }
            if ($cat->title == 'Electronisch afval') {
                unset($listCategories[$key]);
            }
        }

        $params = [
            'id' => $id,
            'user' => $user,
            'dec' => $dec,
            'listCategories' => $listCategories,
            'listType' => $listType,
            'year' => $year
        ];

        return view('front.cma', $params);
    }


    /////////////////////////////////
    public function pma(Request $request)
    {

        $user = Auth::user();
        $data = $request->all();

        $mode = $data['mode'];

        /*New change for q6*/
        $user = Auth::user();
        $user_id = $user->id;
        $userPeriod = new UserPeriod();
        $user_period_id = (int)$data['period_id'];

        $period_id = $userPeriod->getPeriodId($user_period_id);
        $periodObj = Period::where('id', $period_id)->firstOrFail();
        $year = $periodObj->group_period;
        /* check if Q6 */
        if ($year < 2022) {
            $listType = DeclarationType::where('is_deleted', AppConstant::NOT_DELETED)
                ->where('old_sort', '>=', 1)
                ->orderBy('old_sort', 'asc')->get();
        } else {
            $listType = DeclarationType::where('is_deleted', AppConstant::NOT_DELETED)
                ->where('sort', '>=', 1)
                ->orderBy('sort', 'asc')->get(); // phmd
        }
        if ($year >= 2025) {
            //triple isolatieglas, dubbel isolatieglas, 
            $listType = DeclarationType::where('is_deleted', AppConstant::NOT_DELETED)
                ->whereIn('id', [14, 12, 13])
                ->orderBy('sort', 'asc')->get(); // phmd
        }
        $do_change = [false, false];
        if ($periodObj->type == 3) {

            foreach ([12, 14] as $ind => $id) {
                $the_detail = [];
                $the_type_id = 0;
                $the_ind_submit = -1;
                if (!empty($data['dec'])) {
                    foreach ($data['dec'] as $indSubmit => $detail) {
                        $type_id = $detail['type_id'];
                        /* check if only isolatieglas  */
                        if ($type_id == $id) {
                            $the_type_id = $type_id;
                            $the_detail = $detail;
                            $the_ind_submit = $indSubmit;
                            break;
                        }
                    }
                }

                $user_period_ids = $this->_get_user_period_ids($year, $user_id);
                $userPeriodOBJ = UserPeriod::where('id', '=', $user_period_id)->first();
                $PeriodOBJ = Period::where('id', '=', $userPeriodOBJ->period_id)->first();
                $declarationModel = new Declaration();
                $listOfCategoryFilled = $declarationModel->getListOfDeclarationByUserIdAndSeperateByType($user_id, $user_period_ids);
                $arrayDataOfCategoryFilled = array();
                foreach ($listOfCategoryFilled as $_declare) {
                    $v_type_id = $_declare['type_id'];
                    $arrayDataOfCategoryFilled[$v_type_id] = $_declare->toArray();
                }

                $the_old_detail = @$arrayDataOfCategoryFilled[$the_type_id];
                if (!isset($the_change['imp_turk'])) {
                    $the_change['imp_turk'] = null;
                }
                if ($the_old_detail) {
                    $the_change = [];
                    $the_change['type_id'] = $the_detail['type_id'];
                    $the_change['status'] = $the_detail['status'];
                    $the_change['pro_nl'] = $the_detail['pro_nl'];
                    $the_change['imp_be'] = $the_detail['imp_be'];
                    $the_change['imp_be'] = $the_detail['imp_be'];
                    $the_change['imp_de'] = $the_detail['imp_de'];
                    $the_change['imp_po'] = $the_detail['imp_po'];
                    $the_change['imp_turk'] = isset($the_detail['imp_turk']) ? $the_detail['imp_turk'] : null;

                    if ($the_detail['total_m2'] < $the_old_detail['total_m2']) {
                        $the_change['status'] = 1;
                        $the_change['import'] = $the_old_detail['total_import'] - $the_detail['import'];
                        $the_change['total_m2'] = $the_old_detail['total_m2'] - $the_detail['total_m2'];
                        $the_change['weight'] = $the_detail['weight'];
                        $the_change['unit_price'] = $the_detail['unit_price'];
                        $the_change['total'] = $the_old_detail['total_of_total'] - $the_detail['total'];
                        $the_change['btw'] = $the_old_detail['total_btw'] - $the_detail['btw'];
                        $the_change['total_btw'] = $the_old_detail['total_of_total_btw'] - $the_detail['total_btw'];
                        $the_change['imp_de'] = $the_old_detail['total_imp_de'] - $the_detail['imp_de'];

                        $fm['total_m2_fm'] = '- ' . $the_change['total_m2'];
                        $fm['total_fm'] = '-€ ' . $the_change['total'];
                        $fm['btw_fm'] = '-€ ' . $the_change['btw'];
                        $fm['total_btw_fm'] = '-€ ' . $the_change['total_btw'];
                        $the_change['fm'] = json_encode($fm);
                        $the_change['plus_or_minus'] = 'minus';
                    } else {
                        // if new value greater than old
                        $the_change['status'] = 1;
                        $the_change['import'] = $the_detail['import'] - $the_old_detail['total_import'];
                        $the_change['total_m2'] = $the_detail['total_m2'] - $the_old_detail['total_m2'];
                        $the_change['weight'] = $the_detail['weight'];
                        $the_change['unit_price'] = $the_detail['unit_price'];
                        $the_change['total'] = $the_detail['total'] - $the_old_detail['total_of_total'];
                        $the_change['btw'] = $the_detail['btw'] - $the_old_detail['total_btw'];
                        $the_change['total_btw'] = $the_detail['total_btw'] - $the_old_detail['total_of_total_btw'];
                        $the_change['imp_de'] = $the_detail['imp_de'] - $the_old_detail['total_imp_de'];

                        $fm['total_m2_fm'] = '+ ' . $the_change['total_m2'];
                        $fm['total_fm'] = '+€ ' . $the_change['total'];
                        $fm['btw_fm'] = '+€ ' . $the_change['btw'];
                        $fm['total_btw_fm'] = '+€ ' . $the_change['total_btw'];
                        $the_change['fm'] = json_encode($fm);
                        $the_change['plus_or_minus'] = 'plus';
                    }
                } else {
                    $the_change = [];
                    $the_change['type_id'] = $the_detail['type_id'];
                    $the_change['status'] = $the_detail['status'];
                    $the_change['pro_nl'] = $the_detail['pro_nl'];
                    $the_change['imp_be'] = $the_detail['imp_be'];
                    $the_change['imp_be'] = $the_detail['imp_be'];
                    $the_change['imp_de'] = $the_detail['imp_de'];
                    $the_change['imp_po'] = $the_detail['imp_po'];
                    $the_change['imp_turk'] = isset($the_detail['imp_turk']) ? $the_detail['imp_turk'] : null;
                    $the_change['import'] = $the_detail['import'];
                    $the_change['total_m2'] = $the_detail['total_m2'];
                    $the_change['weight'] = $the_detail['weight'];
                    $the_change['unit_price'] = $the_detail['unit_price'];
                    $the_change['total'] = $the_detail['total'];
                    $the_change['btw'] = $the_detail['btw'];
                    $the_change['total_btw'] = $the_detail['total_btw'];
                }


                $data['dec'][$the_ind_submit] = $the_change;
                $do_change[$ind] = true;
            }
        }
        /*End New change for q6*/


        if (!empty($data['dec'])) {
            $mes = $this->makeMessage('dec', ['type_id', 'abc'], count($data['dec']));
        } else {
            $mes = [];
        }
        $hasError = false;

        $mes = array_merge($mes, [
            'required' => 'Het :attribute is verplicht.',
            'password.required' => 'Het wachtwoordveld is verplicht.',
            'name.required' => 'Het naamveld is verplicht.',
            'place.required' => 'Het veld plaats is verplicht.',
            'phone.required' => 'Het veld telefoon is verplicht.',
        ]);


        //if mode submit please let laravel validate
        if ($mode == "submit") {

            if (session()->has('fromAdmin')) {
                unset($data['password']);
                $validator = Validator::make($data, [
                    'name' => 'required',
                    'place' => 'required',
                    'phone' => 'required',
                    'period_id' => 'required',
                    'dec.*.type_id' => 'required',
                    'dec.*.status' => 'required'
                ], $mes);
            } else {
                $validator = Validator::make($data, [
                    'password' => 'required',
                    'name' => 'required',
                    'place' => 'required',
                    'phone' => 'required',
                    'period_id' => 'required',
                    'dec.*.type_id' => 'required',
                    'dec.*.status' => 'required'
                ], $mes);
            }


            if (!empty($data['status'])) {
                foreach ($data['status'] as $key => $v) {
                    $validator->sometimes([
                        'dec.' . $key . '.pro_nl',
                        'dec.' . $key . '.imp_be',
                        'dec.' . $key . '.imp_de',
                        'dec.' . $key . '.imp_po',
                        'dec.' . $key . '.imp_turk',
                        'dec.' . $key . '.import'
                    ], 'required', function ($input) use ($key) {
                        return $input->status[$key] == AppConstant::D_STATUS_ACTIVE;
                    });
                }
            }


            if (!empty($data['password'])) {
                $password = $data['password'];
                $validator->after(function ($validator) use ($user, $password) {
                    if (!Hash::check($password, $user->getAuthPassword())) {
                        $validator->errors()->add('password', 'Wachtwoord is niet correct! controleer alstublieft nog een keer.');
                    }
                });
            }

            if ($validator->fails()) {
                if (isset($data['_reference'])) {
                    return redirect($data['_reference'])->withErrors($validator->errors())->withInput();
                }
                return redirect(route('home.cma', ['id' => $data['period_id']]))->withErrors($validator->errors())->withInput();
            }
        }
        $insert = [];
        $insertNone = [];
        foreach ($data['dec'] as $key => $detail) {
            $type = $detail['type_id'];
            $dectype = DeclarationType::where('id', $type)->first();

            if (!isset($year)) {
                $userPeriod = new UserPeriod();
                $year = $userPeriod->getYearOfPeriod($data['period_id']);
            }
            if ($year >= 2025 && in_array($type, [12, 14])) {
                $dectype->unit_price = 0.4;
            }
            $price = !empty($dectype->id) ? $dectype->unit_price : AppConstant::DEFAULT_PRICE;
            $minimum_validate = $dectype->minimum_validate;
            if ($detail['status'] == AppConstant::D_STATUS_INACTIVE) {
                $insertNone[] = [
                    'user_period_id' => $data['period_id'],
                    'type_id' => $detail['type_id'],
                    'user_id' => $user->id,
                    'unit_price' => $price,
                    'status' => $detail['status'],
                    'name' => $data['name'],
                    'place' => $data['place'],
                    'phone' => $data['phone'],
                    'date' => now()
                ];
            } else {
                $tax = $user->land == 'NL' ? 21 : 0;
                $pro_nl = doubleval(str_replace(",", ".", $detail['pro_nl']));
                $imp_be = doubleval(str_replace(",", ".", $detail['imp_be']));
                $imp_de = doubleval(str_replace(",", ".", $detail['imp_de']));
                $imp_po = doubleval(str_replace(",", ".", $detail['imp_po']));
                $imp_turk = isset($detail['imp_turk']) ? doubleval(str_replace(",", ".", $detail['imp_turk'])) : 0;
                $import = doubleval(str_replace(",", ".", $detail['import']));

                // Parse kg fields
                $pro_nl_kg = isset($detail['pro_nl_kg']) ? doubleval(str_replace(",", ".", $detail['pro_nl_kg'])) : 0;
                $imp_be_kg = isset($detail['imp_be_kg']) ? doubleval(str_replace(",", ".", $detail['imp_be_kg'])) : 0;
                $imp_de_kg = isset($detail['imp_de_kg']) ? doubleval(str_replace(",", ".", $detail['imp_de_kg'])) : 0;
                $imp_po_kg = isset($detail['imp_po_kg']) ? doubleval(str_replace(",", ".", $detail['imp_po_kg'])) : 0;
                $imp_turk_kg = isset($detail['imp_turk_kg']) ? doubleval(str_replace(",", ".", $detail['imp_turk_kg'])) : 0;
                $import_kg = isset($detail['import_kg']) ? doubleval(str_replace(",", ".", $detail['import_kg'])) : 0;

                $pro_nl = $pro_nl < 0 ? $pro_nl * -1 : $pro_nl;
                $imp_be = $imp_be < 0 ? $imp_be * -1 : $imp_be;
                $imp_de = $imp_de < 0 ? $imp_de * -1 : $imp_de;
                $imp_po = $imp_po < 0 ? $imp_po * -1 : $imp_po;
                $imp_turk = $imp_turk < 0 ? $imp_turk * -1 : $imp_turk;
                $import = $import < 0 ? $import * -1 : $import;

                $pro_nl_kg = $pro_nl_kg < 0 ? $pro_nl_kg * -1 : $pro_nl_kg;
                $imp_be_kg = $imp_be_kg < 0 ? $imp_be_kg * -1 : $imp_be_kg;
                $imp_de_kg = $imp_de_kg < 0 ? $imp_de_kg * -1 : $imp_de_kg;
                $imp_po_kg = $imp_po_kg < 0 ? $imp_po_kg * -1 : $imp_po_kg;
                $imp_turk_kg = $imp_turk_kg < 0 ? $imp_turk_kg * -1 : $imp_turk_kg;
                $import_kg = $import_kg < 0 ? $import_kg * -1 : $import_kg;

                $totalM2 = $pro_nl + $imp_be + $imp_de + $imp_po + $imp_turk + $import;
                $totalM2 = $totalM2 < 0 ? $totalM2 * -1 : $totalM2;

                $weight = $detail['weight'];
                $insert[] = [
                    'user_period_id' => $data['period_id'],
                    'type_id' => $detail['type_id'],
                    'user_id' => $user->id,
                    'status' => $detail['status'],
                    'fm' => @$detail['fm'],
                    'plus_or_minus' => @$detail['plus_or_minus'],
                    'name' => $data['name'],
                    'place' => $data['place'],
                    'phone' => $data['phone'],
                    'date' => now(),
                    'pro_nl' => $pro_nl,
                    'imp_be' => $imp_be,
                    'imp_de' => $imp_de,
                    'imp_po' => $imp_po,
                    'imp_turk' => $imp_turk,
                    'import' => $import,
                    'total_m2' => $totalM2,
                    'unit_price' => $price,
                    'total' => $totalM2 * $price,
                    'btw' => ($totalM2 * $price * $tax) / 100,
                    'weight' => $weight,
                    'total_btw' => ($totalM2 * $price * ($tax + 100)) / 100,
                    // Add kg fields
                    'pro_nl_kg' => $pro_nl_kg,
                    'imp_be_kg' => $imp_be_kg,
                    'imp_de_kg' => $imp_de_kg,
                    'imp_po_kg' => $imp_po_kg,
                    'imp_turk_kg' => $imp_turk_kg,
                    'import_kg' => $import_kg,
                ];
                $indKey = array_search($detail['type_id'], [12, 14]);
                if ($indKey >= 0 && $do_change[$indKey] && isset($insert[$key]) && isset($data['dec'][$key])) {
                    $insert[$key] = array_merge($insert[$key], $data['dec'][$key]);
                }
            }
        }


        if ($mode == "submit") {
            //Empty declaration
            //Declaration::where('user_period_id','=',$data['period_id'])->delete();
            Declaration::where('user_period_id', $data['period_id'])->delete();
            //            if($user->user_name == 931){
            //                echo json_encode($insert). PHP_EOL;
            //                echo json_encode($insertNone). PHP_EOL;
            //            }
            //Create declaration
            Declaration::insert($insert);
            Declaration::insert($insertNone);
            if (count($insert) > 0) {
                $pStatus = UserPeriod::STATUS_CREATED;
            } else {
                $pStatus = UserPeriod::STATUS_NONE;
            }
            $userPeriod = new UserPeriod();
            $user_period_id = $data['period_id'];
            $period_id = $userPeriod->getPeriodId($user_period_id);
            $numberPDF = $userPeriod->getCountNumberInPeriodIdWithPDF($period_id);
            $numberPDF++;
            $periodObj = Period::where('id', $period_id)->firstOrFail();
            $current_timestamp = Carbon::now()->timestamp;
            $file_name = $periodObj->period . '' . $numberPDF . ".pdf";
            $ubl_name = $periodObj->period . '' . $numberPDF . ".xml";
            //2020Q1-182763182763687.pdf
            UserPeriod::where('id', $data['period_id'])
                ->update([
                    'status' => $pStatus,
                    'name' => $data['name'],
                    'place' => $data['place'],
                    'phone' => $data['phone'],
                    'file_pdf_name' => $file_name,
                    'file_ubl_name' => $ubl_name,
                ]);
            $file_name_data = str_replace(".pdf", "", $file_name);
            //Create pdf in here
            $array_patch = $this->createdf($user_period_id, $file_name_data);
            $ubl_file = $this->_create_ubl($user_period_id, $file_name_data);
            //Send email to customer
            //Mail::to(AppConstant::getAdminEmail())->queue(new NotiAdmin($user->user_name));
            /* disabl send email */

            Mail::to($user->email)->send(new DeclarationCustomer(
                $periodObj->period,
                $array_patch['full_patch'],
                $ubl_file['full_patch']
            ));
            //Send email to admin
            $date_declaration = now();

            Mail::to(AppConstant::getAdminEmail())->send(
                new DeclarationAdmin(
                    $periodObj->period,
                    $user->oav_number,
                    $data['place'],
                    $date_declaration,
                    $data['name'],
                    $data['phone'],
                    $array_patch['full_patch'],
                    $ubl_file['full_patch']
                )
            );

            //Send second email

            Mail::to(AppConstant::getSecondAdminEmail())->send(
                new DeclarationAdmin(
                    $periodObj->period,
                    $user->oav_number,
                    $data['place'],
                    $date_declaration,
                    $data['name'],
                    $data['phone'],
                    $array_patch['full_patch'],
                    $ubl_file['full_patch']
                )
            );

            // delete declaration temp
            $declarationTemp = new DeclarationTemp();
            $result = $declarationTemp->deleteDetailDeclarationTemp($data['period_id']);
            return redirect(route('home.ma'))->with(['b_message' => 'Uw verzoek is verzonden!', 'listType' => $listType]);
            //End create
        } else {
            // delete declaration temp
            $declarationTemp = new DeclarationTemp();
            $result = $declarationTemp->deleteDetailDeclarationTemp($data['period_id']);
            foreach ($insert as $key => $item) {
                $insert[$key]['user_id'] = $user->id;
            }
            foreach ($insertNone as $key => $item) {
                $insertNone[$key]['user_id'] = $user->id;
            }
            DeclarationTemp::insert($insert);
            DeclarationTemp::insert($insertNone);
            UserPeriod::where('id', $data['period_id'])
                ->update([
                    'status' => 0,
                    'name' => $data['name'],
                    'place' => $data['place'],
                    'phone' => $data['phone']
                ]);
            return redirect()->route('home.cma', ['id' => $data['period_id'], 'listType' => $listType])->with(['b_message' => 'Uw aangifte is opgeslagen, u kunt later verder gaan.', 'listType' => $listType]);
        }
    }

    public function showCreditMemo($id, $year)
    {
        $user = Auth::user();
        //        $listType = DeclarationType::where('is_deleted', AppConstant::NOT_DELETED)->get();
        if ($year < 2022) {
            $listType = DeclarationType::where('is_deleted', AppConstant::NOT_DELETED)
                ->where('old_sort', '>=', 1)
                ->orderBy('old_sort', 'asc')->get();
        } else {
            $listType = DeclarationType::where('is_deleted', AppConstant::NOT_DELETED)
                ->where('sort', '>=', 1)
                ->orderBy('sort', 'asc')->get(); // phmd
        }
        if ($year >= 2025) {
            //triple isolatieglas, dubbel isolatieglas, 
            $listType = DeclarationType::where('is_deleted', AppConstant::NOT_DELETED)
                ->whereIn('id', [14, 12, 13])
                ->orderBy('sort', 'asc')->get(); // phmd
        }

        // echo '<pre>';
        // print_r($listType->toArray());
        // die();
        //$listType = AppConstant::getListPeriodType();
        $userPeriod = new UserPeriod();
        //$dec = $userPeriod->getDetailDeclarationTemp($id);
        $categoryModel = new Categories();
        $listCategories = $categoryModel->getAllCategories();
        $electronischafval = Auth::user()->electronischafval;
        $glasafval = Auth::user()->glasafval;
        foreach ($listCategories as $key => $cat) {
            if ($electronischafval != 1) {
                if ($cat->title == 'Electronisch afval') {
                    unset($listCategories[$key]);
                }
            }
            if ($glasafval != 1) {
                if ($cat->title == 'Glas') {
                    unset($listCategories[$key]);
                }
            }
            if ($cat->title == 'Electronisch afval') {
                unset($listCategories[$key]);
            }
        }


        $user_id = $user->id;

        $user_period_id = $id;
        $user_period_ids = $this->_get_user_period_ids($year, $user->id);

        $userPeriodOBJ = UserPeriod::where('id', '=', $id)->first();
        $PeriodOBJ = Period::where('id', '=', $userPeriodOBJ->period_id)->first();

        $declarationModel = new Declaration();
        $listOfCategoryFilled = $declarationModel->getListOfDeclarationByUserIdAndSeperateByType($user_id, $user_period_ids);
        $arrayDataOfCategoryFilled = array();
        foreach ($listOfCategoryFilled as $_declare) {
            $type_id = $_declare['type_id'];
            $arrayDataOfCategoryFilled[$type_id] = $_declare;
        }
        $params = [
            'id' => $id,
            'user' => $user,
            'listCategories' => $listCategories,
            'listType' => $listType,
            'list_of_sum_declare' => $arrayDataOfCategoryFilled,
            'year' => $year,
            'PeriodType' => $PeriodOBJ->type,
        ];

        return view('front.credit-memo', $params);
    }

    public function agreeCreditMemo(Request $request)
    {
        $data = $request->all();
        $period_id = $data["period_id"];
        $file_pdf = $data["file_pdf"];
        $user_id = Auth::user()->id;
        $modelUserPeriod = new UserPeriod();
        $userPeriod = $modelUserPeriod->getPeriodById($period_id);


        $arrayResult = array(
            "err" => false,
            "msg" => ""
        );
        if ($userPeriod) {
            try {
                $userPeriod->agree_on_creditmemo = 1;
                $userPeriod->status = 1;
                $userPeriod->file_pdf_credit_memo_as_gree = $file_pdf;
                $userPeriod->file_pdf_name = $file_pdf;
                $userPeriod->save();
            } catch (Exception $e) {

                $arrayResult["err"] = true;
                $arrayResult["msg"] = "";
            }
            //Make decleration
        }
        return \response()->json($arrayResult);
    }

    private function makeMessage($main, $fields, $count)
    {
        $result = [];
        foreach ($fields as $field) {
            for ($i = 0; $i < $count; $i++) {
                $result[$main . "." . $i . "." . $field . ".required"] = $field . ' [' . $i . '] is verplicht';
            }
        }

        return $result;
    }

    public function pru(Request $request)
    {
        $data = $request->all();

        $validator = Validator::make($data, [
            'oav_date' => 'nullable|date_format:Y-m-d'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'fail'
            ]);
        } else {
            $user = Auth::user();
            $userUpdate = new UserUpdate();
            $userUpdate->requestUpdate($user->id, $data);

            return response()->json([
                'status' => 'success'
            ]);
        }
    }

    public function renderPrivacy()
    {
        return view('front.privacy', array());
    }

    public function renderCookies()
    {
        return view('front.cookie', array());
    }

    public function renderDisclaimer()
    {
        return view('front.disclaim', array());
    }

    public function makeImport()
    {
        $user = new User();
        //$user->importUser();
        //$user->importInvoice();
        $user->updatePeriodUser();
        die;
    }

    private function createdf($id, $file_name_data)
    {
        set_time_limit(300);

        $user = Auth::user();

        $declarationModel = new Declaration();
        $declarationObj = $declarationModel->GetDeclarationById($id);
        $listOfDeclareObject = $declarationModel->getListDeclaration($id);
        // get user_period_id
        $userPeriodModel = new UserPeriod();
        $userPeriodId = $userPeriodModel->getPeriodId($declarationObj->user_period_id);
        $userPeriod = $userPeriodModel->getPeriodData($declarationObj->user_period_id);
        $periodObj = Period::where('id', $userPeriodId)->firstOrFail();
        $year = $periodObj->group_period;
        /* check if Q6 */
        if ($year < 2022) {
            $listType = DeclarationType::where('is_deleted', AppConstant::NOT_DELETED)
                ->where('old_sort', '>=', 1)
                ->orderBy('old_sort', 'asc')->get();
        } else {
            $listType = DeclarationType::where('is_deleted', AppConstant::NOT_DELETED)
                ->where('sort', '>=', 1)
                ->orderBy('sort', 'asc')->get(); // phmd
        }
        if ($year >= 2025) {
            //triple isolatieglas, dubbel isolatieglas, 
            $listType = DeclarationType::where('is_deleted', AppConstant::NOT_DELETED)
                ->whereIn('id', [14, 12, 13])
                ->orderBy('sort', 'asc')->get(); // phmd
        }
        $data = [
            'user' => $user,
            'declarationObj' => $declarationObj,
            'listOfDeclareObject' => $listOfDeclareObject,
            'periodObj' => $periodObj,
            'file_name_data' => $file_name_data,
            'userPeriod' => $userPeriod,
            'listType' => $listType,
            'year' => $year
        ];

        $pdf = PDF::loadView('dompdf.declaration', $data);

        $current_timestamp = Carbon::now()->timestamp; // Produces something like 1552296328
        //First get count user make pdf for this period and increase number
        //$number = $periodObj->id;
        //$file_name = $periodObj->period.''.$current_timestamp.".pdf";
        $file_name = $userPeriod->file_pdf_name;
        // get path to save file pdf
        $path = Storage::disk('public')->path("pdf");

        // save file pfd
        $pdf->Output($path . '/' . $file_name, 'F');
        $pdf->save($path . '/' . $file_name);
        $full_path = $path . '/' . $file_name;
        return array(
            "url_file" => env('APP_URL') . '/storage/pdf/' . $file_name,
            "full_patch" => $full_path
        );
    }

    private function _create_ubl($id, $file_name_data)
    {

        $user = Auth::user();

        $declarationModel = new Declaration();
        $declarationObj = $declarationModel->GetDeclarationById($id);
        $listOfDeclareObject = $declarationModel->getListDeclaration($id);
        // get user_period_id
        $userPeriodModel = new UserPeriod();
        $userPeriodId = $userPeriodModel->getPeriodId($declarationObj->user_period_id);
        $userPeriod = $userPeriodModel->getPeriodData($declarationObj->user_period_id);
        $periodObj = Period::where('id', $userPeriodId)->firstOrFail();
        $data = [
            'user' => $user,
            'declarationObj' => $declarationObj,
            'listOfDeclareObject' => $listOfDeclareObject,
            'periodObj' => $periodObj,
            'file_name_data' => $file_name_data,
        ];

        $total_nl222 = 0.00;
        $total_be = 0.00;
        $total_de = 0.00;
        $total_po = 0.00;
        $total_import = 0.00;

        $sumRecyclingbijdra = $sumBijdrage = $sumBTW = $sumIncl = 0;

        foreach ($listOfDeclareObject as $k => $_declare) {
            $sumRecyclingbijdra += $_declare->unit_price;
            $sumBijdrage += $_declare->total;
            $sumBTW += $_declare->btw;
            $sumIncl += $_declare->total_btw;
        }

        // << phinq
        $declaration_unit_price = isset($declarationObj->unit_price) ? $declarationObj->unit_price : 0;
        // default: replace $declaration_unit_price by 0.3 -> old rule in this file of code.
        // >> phinq

?>
        <?php ob_start(); ?>
        <?php echo '<?xml version="1.0" encoding="UTF-8"?>'; ?>

        <Invoice xmlns="urn:oasis:names:specification:ubl:schema:xsd:Invoice-2"
            xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2"
            xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2">
            <cbc:UBLVersionID>2.1</cbc:UBLVersionID>
            <cbc:ID><?= $file_name_data; ?></cbc:ID>
            <cbc:IssueDate><?php echo date('Y-m-d'); ?></cbc:IssueDate>
            <cbc:InvoiceTypeCode listID="UN/ECE 1001 Subset" listAgencyID="6">380</cbc:InvoiceTypeCode>
            <cbc:Note languageID="en"><?= trim($user->oav_number); ?>/<?= $file_name_data; ?></cbc:Note>
            <cbc:TaxPointDate><?php echo date('Y-m-d'); ?></cbc:TaxPointDate>
            <cbc:DocumentCurrencyCode listID="ISO 4217 Alpha" listAgencyID="6">EUR</cbc:DocumentCurrencyCode>
            <cbc:AccountingCost />
            <cac:OrderReference>
                <cbc:ID><?= $file_name_data; ?></cbc:ID>
            </cac:OrderReference>
            <cac:AccountingSupplierParty>
                <cac:Party>
                    <cac:PartyName>
                        <cbc:Name>Onafhankelijke Administratie Vlakglas (OAV)</cbc:Name>
                    </cac:PartyName>
                    <cac:PostalAddress>
                        <cbc:Postbox>Postbus 340</cbc:Postbox>
                        <cbc:StreetName>Zilverstraat</cbc:StreetName>
                        <cbc:AdditionalStreetName></cbc:AdditionalStreetName>
                        <cbc:BuildingNumber>69</cbc:BuildingNumber>
                        <cbc:CityName>Zoetermeer</cbc:CityName>
                        <cbc:PostalZone>2700 AH</cbc:PostalZone>
                        <cac:Country>
                            <cbc:IdentificationCode listID="ISO3166-1" listAgencyID="6">NL</cbc:IdentificationCode>
                        </cac:Country>
                    </cac:PostalAddress>
                    <cac:PartyTaxScheme>
                        <cbc:CompanyID>NL856433779B01</cbc:CompanyID>
                        <cac:TaxScheme />
                    </cac:PartyTaxScheme>
                </cac:Party>
            </cac:AccountingSupplierParty>
            <cac:AccountingCustomerParty>
                <cac:Party>
                    <cac:PartyIdentification>
                        <cbc:ID schemeID="0106"><?= $user->kvk_number; ?></cbc:ID>
                    </cac:PartyIdentification>
                    <cac:PartyName>
                        <cbc:Name><?= str_replace('&', '', $user->company_name); ?></cbc:Name>
                    </cac:PartyName>
                    <cac:PostalAddress>
                        <cbc:Postbox></cbc:Postbox>
                        <cbc:StreetName><?= $user->address; ?></cbc:StreetName>
                        <cbc:AdditionalStreetName></cbc:AdditionalStreetName>
                        <cbc:BuildingNumber></cbc:BuildingNumber>
                        <cbc:Department></cbc:Department>
                        <cbc:CityName><?= $user->place; ?></cbc:CityName>
                        <cbc:PostalZone><?= $user->postcode; ?></cbc:PostalZone>
                        <cac:Country>
                            <cbc:IdentificationCode listID="ISO3166-1" listAgencyID="6">NL</cbc:IdentificationCode>
                        </cac:Country>
                    </cac:PostalAddress>
                    <cac:PartyTaxScheme>
                        <cbc:CompanyID schemeID="NL:VAT" schemeAgencyID="ZZZ"><?= $user->btw_number; ?></cbc:CompanyID>
                        <cac:TaxScheme>
                            <cbc:ID schemeID="UN/ECE 5153" schemeAgencyID="6">BTW</cbc:ID>
                        </cac:TaxScheme>
                    </cac:PartyTaxScheme>
                </cac:Party>
            </cac:AccountingCustomerParty>
            <cac:PaymentMeans>
                <cbc:PaymentMeansCode listID="UN/ECE 4461">1</cbc:PaymentMeansCode>
                <cbc:PaymentDueDate><?php echo date('Y-m-d'); ?></cbc:PaymentDueDate>
                <cbc:PaymentChannelCode>IBAN</cbc:PaymentChannelCode>
                <cbc:PaymentID><?= trim($user->oav_number); ?>/<?= $file_name_data; ?></cbc:PaymentID>
                <cac:PayeeFinancialAccount>
                    <cbc:ID><?= $user->btw_number; ?></cbc:ID>
                    <cac:FinancialInstitutionBranch>
                        <cac:FinancialInstitution>
                            <cbc:ID>RABONL2U</cbc:ID>
                        </cac:FinancialInstitution>
                    </cac:FinancialInstitutionBranch>
                </cac:PayeeFinancialAccount>
            </cac:PaymentMeans>
            <cac:PaymentTerms>
                <cbc:Note>Het bedrag van de verschuldigde recyclingbijdrage inclusief BTW moet u betalen voor op
                    bankrekeningnummer IBAN: NL10RABO 0322 4366 05 t.n.v. Fonds Vlakglas Recycling Nederland, Zoetermeer
                </cbc:Note>
            </cac:PaymentTerms>
            <cac:LegalMonetaryTotal>
                <cbc:LineExtensionAmount currencyID="EUR"><?= $sumRecyclingbijdra; ?></cbc:LineExtensionAmount>
                <cbc:TaxExclusiveAmount currencyID="EUR"><?= $sumBijdrage; ?></cbc:TaxExclusiveAmount>
                <cbc:TaxInclusiveAmount currencyID="EUR"><?= $sumIncl; ?></cbc:TaxInclusiveAmount>
                <cbc:PayableAmount currencyID="EUR"><?= $sumIncl; ?></cbc:PayableAmount>
            </cac:LegalMonetaryTotal>

            <?php
            $sumRecyclingbijdra = $sumBijdrage = $sumBTW = $sumIncl = 0;
            foreach ($listOfDeclareObject as $k => $_declare) :
                /// << phinq
                // just output firt row - here is isolatieglas
                ///if ($k > 0) continue;

                // not need add to ubl if all values in row = 0
                $is_validated = $_declare->pro_nl > 0 || $_declare->imp_be > 0 || $_declare->imp_de > 0 || $_declare->imp_po > 0 || $_declare->imp_turk > 0 || $_declare->import;
                if ($is_validated === false) continue;
                /// >> phinq

                $sumRecyclingbijdra += $_declare->unit_price;
                $sumBijdrage += $_declare->total;
                $sumBTW += $_declare->btw;
                $sumIncl += $_declare->total_btw;
                $pro_nl222 = $_declare->pro_nl;
                $imp_be222 = $_declare->imp_be; // => België
                $imp_de222 = $_declare->imp_de;
                $imp_po222 = $_declare->imp_po; // => Polen
                $imp_turk222 = $_declare->imp_turk; // => Turkije
                $import222 = $_declare->import; // => overige
                if (!$pro_nl222) {
                    $pro_nl222 = 0;
                }
                if (!$imp_be222) {
                    $imp_be222 = 0;
                }
                if (!$imp_de222) {
                    $imp_de222 = 0;
                }
                if (!$imp_po222) {
                    $imp_po222 = 0;
                }
                if (!$imp_turk222) {
                    $imp_turk222 = 0;
                }
                if (!$import222) {
                    $import222 = 0;
                }

                $pro_nl22 = str_replace(".", ",", $pro_nl222);
                $imp_be22 = str_replace(".", ",", $imp_be222);
                $imp_de22 = str_replace(".", ",", $imp_de222);
                $imp_po22 = str_replace(".", ",", $imp_po222);
                $imp_turk22 = str_replace(".", ",", $imp_turk222);
                $import22 = str_replace(".", ",", $import222);
            ?>
                <?php if ($pro_nl222): ?>
                    <cac:InvoiceLine>
                        <cbc:ID><?= $k + 1; ?></cbc:ID>
                        <cbc:Note><?= trim($user->oav_number); ?>/<?= $file_name_data; ?></cbc:Note>
                        <cbc:InvoicedQuantity unitCode="C62"><?= $pro_nl222; ?></cbc:InvoicedQuantity>
                        <cbc:LineExtensionAmount
                            currencyID="EUR"><?= $pro_nl222 * $_declare->unit_price; ?></cbc:LineExtensionAmount>
                        <cbc:AccountingCostCode>8901</cbc:AccountingCostCode>
                        <cac:OrderLineReference>
                            <cbc:LineID>1</cbc:LineID>
                        </cac:OrderLineReference>
                        <cac:TaxTotal>
                            <cbc:TaxAmount
                                currencyID="EUR"><?= ($pro_nl222 * $_declare->unit_price) * 0.21; ?></cbc:TaxAmount>
                        </cac:TaxTotal>
                        <cac:Item>
                            <cbc:Description languageID="NL"><?= trim($user->oav_number); ?>
                                /<?= $file_name_data; ?></cbc:Description>
                            <ClassifiedTaxCategory
                                xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2">
                                <cbc:ID schemeID="UN/ECE 5305" schemeAgencyID="6">6</cbc:ID>
                                <cbc:Percent>21</cbc:Percent>
                                <TaxScheme>
                                    <cbc:ID schemeID="UN/ECE 5153" schemeAgencyID="6">BTW</cbc:ID>
                                </TaxScheme>
                            </ClassifiedTaxCategory>
                        </cac:Item>
                        <cac:Price>
                            <cbc:PriceAmount currencyID="EUR"><?= $_declare->unit_price ?></cbc:PriceAmount>
                            <cbc:BaseQuantity unitCode="C62">1</cbc:BaseQuantity>
                        </cac:Price>
                    </cac:InvoiceLine>
                <?php endif; ?>

                <?php if ($imp_de222): ?>
                    <cac:InvoiceLine>
                        <cbc:ID><?= $k + 2; ?></cbc:ID>
                        <cbc:Note><?= trim($user->oav_number); ?>/<?= $file_name_data; ?></cbc:Note>
                        <cbc:InvoicedQuantity unitCode="C62"><?= $imp_de222; ?></cbc:InvoicedQuantity>
                        <cbc:LineExtensionAmount
                            currencyID="EUR"><?= $imp_de222 * $_declare->unit_price; ?></cbc:LineExtensionAmount>
                        <cbc:AccountingCostCode>8902</cbc:AccountingCostCode>
                        <cac:OrderLineReference>
                            <cbc:LineID>1</cbc:LineID>
                        </cac:OrderLineReference>
                        <cac:TaxTotal>
                            <cbc:TaxAmount
                                currencyID="EUR"><?= ($imp_de222 * $_declare->unit_price) * 0.21; ?></cbc:TaxAmount>
                        </cac:TaxTotal>
                        <cac:Item>
                            <cbc:Description languageID="NL"><?= trim($user->oav_number); ?>
                                /<?= $file_name_data; ?></cbc:Description>
                            <ClassifiedTaxCategory
                                xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2">
                                <cbc:ID schemeID="UN/ECE 5305" schemeAgencyID="6">6</cbc:ID>
                                <cbc:Percent>21</cbc:Percent>
                                <TaxScheme>
                                    <cbc:ID schemeID="UN/ECE 5153" schemeAgencyID="6">BTW</cbc:ID>
                                </TaxScheme>
                            </ClassifiedTaxCategory>
                        </cac:Item>
                        <cac:Price>
                            <cbc:PriceAmount currencyID="EUR"><?= $_declare->unit_price ?></cbc:PriceAmount>
                            <cbc:BaseQuantity unitCode="C62">1</cbc:BaseQuantity>
                        </cac:Price>
                    </cac:InvoiceLine>
                <?php endif; ?>
                <?php if ($imp_be222 && $imp_be222 > 0): ?>
                    <cac:InvoiceLine>
                        <cbc:ID><?= $k + 3; ?></cbc:ID>
                        <cbc:Note><?= trim($user->oav_number); ?>/<?= $file_name_data; ?></cbc:Note>
                        <cbc:InvoicedQuantity unitCode="C62"><?= $imp_be222; ?></cbc:InvoicedQuantity>
                        <cbc:LineExtensionAmount
                            currencyID="EUR"><?= $imp_be222 * $_declare->unit_price; ?></cbc:LineExtensionAmount>
                        <cbc:AccountingCostCode>8903</cbc:AccountingCostCode>
                        <cac:OrderLineReference>
                            <cbc:LineID>1</cbc:LineID>
                        </cac:OrderLineReference>
                        <cac:TaxTotal>
                            <cbc:TaxAmount
                                currencyID="EUR"><?= ($imp_be222 * $_declare->unit_price) * 0.21; ?></cbc:TaxAmount>
                        </cac:TaxTotal>
                        <cac:Item>
                            <cbc:Description languageID="NL"><?= trim($user->oav_number); ?>
                                /<?= $file_name_data; ?></cbc:Description>
                            <ClassifiedTaxCategory
                                xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2">
                                <cbc:ID schemeID="UN/ECE 5305" schemeAgencyID="6">6</cbc:ID>
                                <cbc:Percent>21</cbc:Percent>
                                <TaxScheme>
                                    <cbc:ID schemeID="UN/ECE 5153" schemeAgencyID="6">BTW</cbc:ID>
                                </TaxScheme>
                            </ClassifiedTaxCategory>
                        </cac:Item>
                        <cac:Price>
                            <cbc:PriceAmount currencyID="EUR"><?= $_declare->unit_price ?></cbc:PriceAmount>
                            <cbc:BaseQuantity unitCode="C62">1</cbc:BaseQuantity>
                        </cac:Price>
                    </cac:InvoiceLine>
                <?php endif; ?>
                <?php if ($imp_po222 && $imp_po222 > 0): ?>
                    <cac:InvoiceLine>
                        <cbc:ID><?= $k + 4; ?></cbc:ID>
                        <cbc:Note><?= trim($user->oav_number); ?>/<?= $file_name_data; ?></cbc:Note>
                        <cbc:InvoicedQuantity unitCode="C62"><?= $imp_po222; ?></cbc:InvoicedQuantity>
                        <cbc:LineExtensionAmount
                            currencyID="EUR"><?= $imp_po222 * $_declare->unit_price; ?></cbc:LineExtensionAmount>
                        <cbc:AccountingCostCode>8904</cbc:AccountingCostCode>
                        <cac:OrderLineReference>
                            <cbc:LineID>1</cbc:LineID>
                        </cac:OrderLineReference>
                        <cac:TaxTotal>
                            <cbc:TaxAmount
                                currencyID="EUR"><?= ($imp_po222 * $_declare->unit_price) * 0.21; ?></cbc:TaxAmount>
                        </cac:TaxTotal>
                        <cac:Item>
                            <cbc:Description languageID="NL"><?= trim($user->oav_number); ?>
                                /<?= $file_name_data; ?></cbc:Description>
                            <ClassifiedTaxCategory
                                xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2">
                                <cbc:ID schemeID="UN/ECE 5305" schemeAgencyID="6">6</cbc:ID>
                                <cbc:Percent>21</cbc:Percent>
                                <TaxScheme>
                                    <cbc:ID schemeID="UN/ECE 5153" schemeAgencyID="6">BTW</cbc:ID>
                                </TaxScheme>
                            </ClassifiedTaxCategory>
                        </cac:Item>
                        <cac:Price>
                            <cbc:PriceAmount currencyID="EUR"><?= $_declare->unit_price ?></cbc:PriceAmount>
                            <cbc:BaseQuantity unitCode="C62">1</cbc:BaseQuantity>
                        </cac:Price>
                    </cac:InvoiceLine>
                <?php endif; ?>
                <?php if ($imp_turk222 && $imp_turk222 > 0): ?>
                    <cac:InvoiceLine>
                        <cbc:ID><?= $k + 4; ?></cbc:ID>
                        <cbc:Note><?= trim($user->oav_number); ?>/<?= $file_name_data; ?></cbc:Note>
                        <cbc:InvoicedQuantity unitCode="C62"><?= $imp_turk222; ?></cbc:InvoicedQuantity>
                        <cbc:LineExtensionAmount
                            currencyID="EUR"><?= $imp_turk222 * $_declare->unit_price; ?></cbc:LineExtensionAmount>
                        <cbc:AccountingCostCode>8906</cbc:AccountingCostCode>
                        <cac:OrderLineReference>
                            <cbc:LineID>1</cbc:LineID>
                        </cac:OrderLineReference>
                        <cac:TaxTotal>
                            <cbc:TaxAmount
                                currencyID="EUR"><?= ($imp_turk222 * $_declare->unit_price) * 0.21; ?></cbc:TaxAmount>
                        </cac:TaxTotal>
                        <cac:Item>
                            <cbc:Description languageID="NL"><?= trim($user->oav_number); ?>
                                /<?= $file_name_data; ?></cbc:Description>
                            <ClassifiedTaxCategory
                                xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2">
                                <cbc:ID schemeID="UN/ECE 5305" schemeAgencyID="6">6</cbc:ID>
                                <cbc:Percent>21</cbc:Percent>
                                <TaxScheme>
                                    <cbc:ID schemeID="UN/ECE 5153" schemeAgencyID="6">BTW</cbc:ID>
                                </TaxScheme>
                            </ClassifiedTaxCategory>
                        </cac:Item>
                        <cac:Price>
                            <cbc:PriceAmount currencyID="EUR"><?= $_declare->unit_price ?></cbc:PriceAmount>
                            <cbc:BaseQuantity unitCode="C62">1</cbc:BaseQuantity>
                        </cac:Price>
                    </cac:InvoiceLine>
                <?php endif; ?>
                <?php if ($import222 && $import222 > 0): ?>
                    <cac:InvoiceLine>
                        <cbc:ID><?= $k + 5; ?></cbc:ID>
                        <cbc:Note><?= trim($user->oav_number); ?>/<?= $file_name_data; ?></cbc:Note>
                        <cbc:InvoicedQuantity unitCode="C62"><?= $import222; ?></cbc:InvoicedQuantity>
                        <cbc:LineExtensionAmount
                            currencyID="EUR"><?= $import222 * $_declare->unit_price; ?></cbc:LineExtensionAmount>
                        <cbc:AccountingCostCode>8905</cbc:AccountingCostCode>
                        <cac:OrderLineReference>
                            <cbc:LineID>1</cbc:LineID>
                        </cac:OrderLineReference>
                        <cac:TaxTotal>
                            <cbc:TaxAmount
                                currencyID="EUR"><?= ($import222 * $_declare->unit_price) * 0.21; ?></cbc:TaxAmount>
                        </cac:TaxTotal>
                        <cac:Item>
                            <cbc:Description languageID="NL"><?= trim($user->oav_number); ?>
                                /<?= $file_name_data; ?></cbc:Description>
                            <ClassifiedTaxCategory
                                xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2">
                                <cbc:ID schemeID="UN/ECE 5305" schemeAgencyID="6">6</cbc:ID>
                                <cbc:Percent>21</cbc:Percent>
                                <TaxScheme>
                                    <cbc:ID schemeID="UN/ECE 5153" schemeAgencyID="6">BTW</cbc:ID>
                                </TaxScheme>
                            </ClassifiedTaxCategory>
                        </cac:Item>
                        <cac:Price>
                            <cbc:PriceAmount currencyID="EUR"><?= $_declare->unit_price ?></cbc:PriceAmount>
                            <cbc:BaseQuantity unitCode="C62">1</cbc:BaseQuantity>
                        </cac:Price>
                    </cac:InvoiceLine>
                <?php endif; ?>
            <?php endforeach; ?>
        </Invoice><?php $outputXMLString = ob_get_clean(); ?>
<?php
        $file_name = $userPeriod->file_ubl_name;
        $path = Storage::disk('public')->path("ubl");
        $full_path = $path . '/' . $file_name;
        file_put_contents($full_path, ltrim($outputXMLString));
        return array(
            "url_file" => env('APP_URL') . '/storage/ubl/' . $file_name,
            "full_patch" => $full_path
        );
        // $dom = new \DOMDocument;
        // $dom->loadXML($outputXMLString);
        // $this->assertEquals(true, $dom->schemaValidate($this->schema));
    }

    private function _get_user_period_ids($year, $user_id)
    {
        $period_ids = Period::select('id')
            ->where('group_period', '=', $year)
            ->where('period', "not like", "%Q6%")
            ->get()
            ->toArray();

        foreach ($period_ids as $key => $period_id) {
            $period_ids[$key] = $period_id['id'];
        }
        $user_period_ids = UserPeriod::select('id')
            ->whereIn('period_id', $period_ids)
            ->where('user_id', '=', $user_id)
            ->get()
            ->toArray();

        foreach ($user_period_ids as $key => $user_period_id) {
            $user_period_ids[$key] = $user_period_id['id'];
        }

        return $user_period_ids;
    }
}
