<?php

namespace App\Imports;

use App\Mail\CreateUser;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;
use Maatwebsite\Excel\Concerns\ToModel;

class UsersImport implements ToModel
{
    public function model(array $it)
    {
        $user = User::whereRaw("
            user_name = ? or email = ?
        ", [$it[0], $it[3]])->get();
        if(count($user) > 0 || count($it) != 18){
            return new User();
        } else {
            $password = Str::random(8);
            Mail::to($it[3])->queue(new CreateUser($it[0], $password));

            return new User([
                "user_name"         => $it[0],
                "password"          => Hash::make($password),
                "first_name"        => $it[1],
                "last_name"         => $it[2],
                "email"             => $it[3],
                "oav_number"        => $it[4],
                "company_name"      => $it[5],
                "address"           => $it[6],
                "postcode"          => $it[7],
                "place"             => $it[8],
                "land"              => $it[9],
                "phone"             => $it[10],
                "fax"               => $it[11],
                "kvk_number"        => $it[12],
                "btw_number"        => $it[13],
                "declaration_type"  => (int)$it[14],
                "declaration_web"   => (int)$it[15],
                "contact"           => $it[16],
                "oav_date"          => $it[17],
                "should_assign"     => 1
            ]);
        }
    }
}
