<?php

namespace App\Jobs;

use App\Models\Period;
use App\Models\User;
use App\Models\UserPeriod;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class AssignPeriod implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct()
    {
        //
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $group = date('Y');
        $periods = Period::where('group_period', $group)->get();
        $insert = [];
        $users = User::where('should_assign', 1)->get();
        $count = 0;
        foreach ($users as $user){
            foreach ($periods as $period){
                $count++;
                $insert[] = [
                    'user_id' => $this->userId,
                    'period_id' => $period->id
                ];

                if($count > 1000){
                    $count = 0;
                    UserPeriod::insert($insert);
                    $insert = [];
                }
            }
        }

        if(!empty($insert)){
            UserPeriod::insert($insert);
        }
    }
}
