<?php

namespace App\Jobs;

use App\Mail\RemindPeriod;
use App\Mail\AssignPeriod;
use App\Models\Period;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;

class SendEmailPeriod implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $_arrayEmail;
    protected $period;
    protected $type;
    protected $_type_email;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($arrayEmail, Period $period, $type, $type_email = 0)
    {
        $this->type = $type;
        $this->_arrayEmail = $arrayEmail;
        $this->period = $period;
        $this->_type_email = $type_email;

    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
		if($this->_type_email == 0){
            $listEmail = [];
            if($this->type == 1){
                $list = User::whereIn('id', $this->_arrayEmail)->get();
            } elseif($this->type == 3){
                $list = User::whereNotIn('id', $this->_arrayEmail)->get();
            } else if($this->type == 4){
                $listEmail = $this->_arrayEmail;
            } elseif($this->type == 5){ // Send to all users who DO NOT submit declaration
                $userModel = new User();
                $listUserNotSubmitDeclaration = $userModel->getUserNotDeclaration($this->period->id);
                $listEmail = $listUserNotSubmitDeclaration->pluck('email');
            } else{
                $list = User::all();
            }

            if(count($listEmail) > 0){
                foreach ($listEmail as $key => $email){
                    if(!empty($email)){
                        $user = User::where('email',$email)->first();
						$when = now()->addSeconds($key);
						Mail::to($email)->later($when, new RemindPeriod($this->period,$user));
                        /*Mail::to($email)->queue(new RemindPeriod($this->period,$user));*/
                    }
                }
            }
            else{
                foreach ($list as $key => $user){
                    if(!empty($user->email)){
                        /*Mail::to($user->email)->queue(new RemindPeriod($this->period,$user));*/
						$when = now()->addSeconds($key);
                        Mail::to($user->email)->later($when, new RemindPeriod($this->period,$user));
                    }
                }
            }
        }
        if($this->_type_email == 1){
            $listEmail = $this->_arrayEmail;
            foreach ($listEmail as $key =>  $email){
                if(!empty($email)){
					$when = now()->addSeconds($key);
					Mail::to($email)->later($when, new AssignPeriod($this->period));
                    /*Mail::to($email)->queue(new AssignPeriod($this->period,$user));*/
                }
            }
        }
    }
}
