<?php

namespace App\Mail;

use App\Helper\AppConstant;
use App\Models\TemplateEmail;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CreateUser extends Mailable
{
    use Queueable, SerializesModels;

    protected $userName;
    protected $password;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($userName, $password)
    {
        $this->userName = $userName;
        $this->password = $password;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $template = TemplateEmail::where('id', AppConstant::MAIL_CREATE_USER)->first();
        if(!empty($template->id)){
            $title = $template->title;
            $text = str_replace('::password::', $this->password, $template->text);
            $text = str_replace('::user_name::', $this->userName, $text);
            $button = $template->button;
            $cc = explode(',', $template->cc_email);
            $bcc = explode(',', $template->bcc_email);

            return $this->markdown('emails.template.mail')
                ->subject($title)
                ->cc(empty($cc[0]) ? [] : $cc)
                ->bcc(empty($bcc[0]) ? [] : $bcc)
                ->with([
                    'title' => $title,
                    'text' => $text,
                    'button' => $button,
                    'url' => route('home.index')
                ]);
        } else {
            return $this->markdown('emails.user.create')
                ->with([
                    'userName' => $this->userName,
                    'password' => $this->password
                ]);
        }
    }
}
