<?php

namespace App\Mail;

use App\Helper\AppConstant;
use App\Models\Period;
use App\Models\User;
use App\Models\Declaration;
use App\Models\TemplateEmail;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class DeclarationCustomer extends Mailable
{
    use Queueable, SerializesModels;

    protected $_period;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($period,$pdf_file,$ubl_file)
    {
		$this->_period = $period;
        $this->_pdf_file = $pdf_file;
        $this->_ubl_file = $ubl_file;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $template = TemplateEmail::where('id', AppConstant::MAIL_CUSTOMER_INVOICE)->first();
        if(!empty($template->id)){
            $title = $template->title;
			$text = str_replace('::periode::', $this->_period, $template->text);
            $button = $template->button;
            $cc = explode(',', $template->cc_email);
            $bcc = explode(',', $template->bcc_email);


            

            $markdown = $this->markdown('emails.template.mail')
            ->subject($title)
            ->cc(empty($cc[0]) ? [] : $cc)
            ->bcc(empty($bcc[0]) ? [] : $bcc)
            ->with([
                'title' => $title,
                'text' => $text,
                'button' => $button
            ]);

            if( $this->_pdf_file ){
                $markdown->attach($this->_pdf_file);
            }
            if( $this->_ubl_file ){
                $markdown->attach($this->_ubl_file);
            }

            return $markdown;
        }
    }
}
