<?php

namespace App\Mail;

use App\Helper\AppConstant;
use App\Models\TemplateEmail;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class InvoiceMail extends Mailable
{
    use Queueable, SerializesModels;    
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct()
    {
        
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $template = TemplateEmail::where('id', AppConstant::MAIL_INVOICE)->first();
        $title = $template->title;
        $text = $template->text;
        $button = $template->button;
        $cc = explode(',', $template->cc_email);
        $bcc = explode(',', $template->bcc_email);
        return $this->markdown('emails.admin.invoice')
            ->subject($title)
            ->cc(empty($cc[0]) ? [] : $cc)
            ->bcc(empty($bcc[0]) ? [] : $bcc)
            ->with([
                'title' => $title,
                'text' => $text
            ]);
    }
}
