<?php



namespace App\Models;



use App\Helper\AppConstant;

use Illuminate\Database\Eloquent\Model;



class Declaration extends Model

{

    /**

     * The attributes that are mass assignable.

     *

     * @var array

     */
protected $fillable = [
    "user_period_id",
    "user_id",
    "type_id",
    "total_m2",
    "period_id",
    "unit_price",
    "total",
    "btw",
    "total_btw",
    "place",
    "date",
    "name",
    "phone",
    "ready",
    "email_sent",
    "reminder",
    "pro_nl",
    "pro_nl_kg",
    "imp_be",
    "imp_be_kg",
    "imp_po",
    "imp_po_kg",
    "imp_de",
    "imp_de_kg",
    "imp_turk",
    "imp_turk_kg",
    "import",
    "import_kg",
    "weight",
    "admin_id",
    "fm",
    "plus_or_minus"
];



    /**

     * The attributes that should be hidden for arrays.

     *

     * @var array

     */

    protected $hidden = [

    ];



    /**

     * The attributes that should be cast to native types.

     *

     * @var array

     */

    protected $casts = [

        'created_at' => 'timestamp',

        'updated_at' => 'timestamp',

        'date' => 'datetime'

    ];



    public function getListFilled($id)

    {

        $query = $this->where('user_id', $id)

            ->join('periods', 'periods.id', '=', 'declarations.period_id')

            ->selectRaw("

                periods.type,

                periods.period,

                periods.description,

                declarations.id

            ")

            ->orderBy('periods.id', 'desc');



        return $query->get();

    }



    public function getDecById($id)

    {

        return $this->where('id', $id)->firstOrFail();

    }



    public function getDeclarationByUserPeriodId($user_period_id)

    {

        return $this->where('user_period_id', '=', $user_period_id)->first();

    }



    public function getListForAdmin()

    {

        $query = $this->join('periods', 'periods.id', '=', 'declarations.period_id')

            ->join('users', 'users.id', '=', 'declarations.user_id')

            ->selectRaw("

                periods.period,

                periods.type,

                periods.description,

                declarations.id,

                users.user_name

            ")

            ->where('declarations.type_id', '<>', AppConstant::DEC_TYPE_NULL)

            ->orderBy("periods.id", 'desc');



        return $query->paginate(config('appvalue.paging'));

    }



    public function getCertificationList($userId)

    {

        $query = $this->where('declarations.user_id', $userId)

            ->join('periods', 'periods.id', '=', 'declarations.period_id')

            ->selectRaw("

                count(periods.id) as number_dec,

                periods.type as period_type,

                periods.group_period,

                periods.description

            ")

            ->where('declarations.type_id', '<>', AppConstant::DEC_TYPE_NULL)

            ->groupBy(['periods.group_period', 'periods.type'])

            ->havingRaw("

                (number_dec = 4 and period_type = ?) or (number_dec = 1 and period_type = ?)

            ", [AppConstant::PERIOD_TYPE_QUARTER, AppConstant::PERIOD_TYPE_YEAR]);



        return $query->get();

    }



    public function checkCert($year, $userId)

    {

        $query = $this->where('declarations.user_id', $userId)

            ->join('periods', 'periods.id', '=', 'declarations.user_period_id')

            ->selectRaw("

                count(periods.id) as number_dec,

                periods.type as period_type,

                periods.group_period,

                periods.description

            ")

            ->where('declarations.type_id', '<>', AppConstant::DEC_TYPE_NULL)

            ->where('periods.group_period', $year)

            ->groupBy(['periods.group_period', 'periods.type'])

            ->havingRaw("

                (number_dec = 4 and period_type = ?) or (number_dec = 1 and period_type = ?)

            ", [AppConstant::PERIOD_TYPE_QUARTER, AppConstant::PERIOD_TYPE_YEAR]);



        $list = $query->get();



        return count($list) > 0;

    }





    /**

     * Get Declaration By User_period_id

     *

     * @param [type] $id user_period_id

     * @return void

     */

    public function GetDeclarationById($id, $year = 'upper')

    {

        $query = Declaration::selectRaw('declaration_types.name as type_name,categories.title as category_name, declarations.*')

            ->join('declaration_types', 'declaration_types.id', '=', 'declarations.type_id')

            ->join('categories', 'categories.id', '=', 'declaration_types.category_id')

            ->where('date', '<>', '0000-00-00 00:00:00')

            ->where('declarations.user_period_id', $id);

        if ($year == 'upper') {

            $query->orderBy('declaration_types.sort', 'asc');

        } else {

            $query->orderBy('declaration_types.old_sort', 'asc');

        }

        $declaration = $query->firstOrFail();

//                                    ->orderBy('declaration_types.sort','asc') // phmd

//                                    ->firstOrFail();

        return $declaration;

    }



    public function GetDeclarationByIdOld($id)

    {

        $declaration = Declaration::selectRaw('declaration_types.name as type_name,categories.title as category_name, declarations.*')

            ->join('declaration_types', 'declaration_types.id', '=', 'declarations.type_id')

            ->join('categories', 'categories.id', '=', 'declaration_types.category_id')

            ->where('date', '<>', '0000-00-00 00:00:00')

            ->where('declarations.user_period_id', $id)

            ->firstOrFail();

        return $declaration;

    }



    /**

     * Get List Declaration

     *

     * @return void

     */

    public function getListDeclaration($user_period_id, $year = 'upper')

    {

        $query = Declaration::selectRaw('
    declaration_types.name as type_name,
    categories.title as category_name,
    categories.id as category_id,
    declaration_types.id as declaration_id,

    declarations.user_period_id,
    declarations.user_id,
    declarations.type_id,
    declarations.total_m2,
    declarations.unit_price,
    declarations.total,
    declarations.btw,
    declarations.total_btw,
    declarations.place,
    declarations.name,
    declarations.phone,
    declarations.ready,
    declarations.email_sent,
    declarations.reminder,

    declarations.pro_nl,
    declarations.pro_nl_kg,

    declarations.imp_be,
    declarations.imp_be_kg,

    declarations.imp_de,
    declarations.imp_de_kg,

    declarations.imp_po,
    declarations.imp_po_kg,

    declarations.imp_turk,
    declarations.imp_turk_kg,

    declarations.import,
    declarations.import_kg,

    declarations.weight,
    declarations.status,
    declarations.fm,
    declarations.plus_or_minus
')

            ->join('declaration_types', 'declaration_types.id', '=', 'declarations.type_id')

            ->join('categories', 'categories.id', '=', 'declaration_types.category_id')

            ->where('declarations.user_period_id', $user_period_id)

            ->where('declarations.status', 1)

            ->groupBy('declaration_types.name', 'categories.title',

                'declarations.user_period_id', 'declarations.user_id', 'declarations.type_id', 'declarations.total_m2', 'declarations.unit_price',

                'declarations.total', 'declarations.btw', 'declarations.total_btw', 'declarations.place', 'declarations.name',

                'declarations.phone', 'declarations.ready', 'declarations.email_sent', 'declarations.reminder', 'declarations.pro_nl', 'declarations.imp_be',

                'declarations.imp_de', 'declarations.imp_po','declarations.imp_turk', 'declarations.import', 'declarations.weight', 'declarations.status');

//                                    ->orderBy('declaration_types.sort','asc') // phmd

//                                    ->get();

        if ($year == 'upper') {

            $query->orderBy('declaration_types.sort', 'asc');

        } else {

            $query->orderBy('declaration_types.old_sort', 'asc');

        }

        $declaration = $query->get();



        return $declaration;

    }



    public function getListDeclarationOld($user_period_id)

    {

        $declaration = Declaration::selectRaw('declaration_types.name as type_name,categories.title as category_name,

                                            declarations.user_period_id,declarations.user_id,declarations.type_id,declarations.total_m2,declarations.unit_price,

                                            declarations.total,declarations.btw,declarations.total_btw,declarations.place,declarations.name,

                                            declarations.phone,declarations.ready,declarations.email_sent,declarations.reminder,declarations.pro_nl,declarations.imp_be,

                                            declarations.imp_de,declarations.imp_po,declarations.imp_turk,declarations.import,declarations.weight,declarations.status')

            ->join('declaration_types', 'declaration_types.id', '=', 'declarations.type_id')

            ->join('categories', 'categories.id', '=', 'declaration_types.category_id')

            ->where('declarations.user_period_id', $user_period_id)

            ->where('declarations.status', 1)

            ->groupBy('declaration_types.name', 'categories.title',

                'declarations.user_period_id', 'declarations.user_id', 'declarations.type_id', 'declarations.total_m2', 'declarations.unit_price',

                'declarations.total', 'declarations.btw', 'declarations.total_btw', 'declarations.place', 'declarations.name',

                'declarations.phone', 'declarations.ready', 'declarations.email_sent', 'declarations.reminder', 'declarations.pro_nl', 'declarations.imp_be',

                'declarations.imp_de', 'declarations.imp_po', 'declarations.imp_turk', 'declarations.import', 'declarations.weight', 'declarations.status')

            ->get();

        return $declaration;

    }



    /**

     * Get Declaration By User id

     *

     * @return void

     */

    public function getDeclarationByUserId($user_id, $user_period_ids = [])

    {

        $declaration = Declaration::selectRaw('declaration_types.name as type_name,categories.title as category_name, declarations.*')

            ->join('declaration_types', 'declaration_types.id', '=', 'declarations.type_id')

            ->join('categories', 'categories.id', '=', 'declaration_types.category_id')

            ->where('declarations.user_id', $user_id)

            ->whereIn('declarations.user_period_id', $user_period_ids)

            ->where('declarations.status', 1)

            ->orderBy('declaration_types.sort', 'asc')// phmd

            ->get();

        return $declaration;

    }



    public function getDeclarationByUserIdOld($user_id, $user_period_ids = [])

    {

        $declaration = Declaration::selectRaw('declaration_types.name as type_name,categories.title as category_name, declarations.*')

            ->join('declaration_types', 'declaration_types.id', '=', 'declarations.type_id')

            ->join('categories', 'categories.id', '=', 'declaration_types.category_id')

            ->where('declarations.user_id', $user_id)

            ->whereIn('declarations.user_period_id', $user_period_ids)

            ->where('declarations.status', 1)

            ->get();

        return $declaration;

    }



    /**

     * Get declaration by user id with seperate by declaration type

     *

     * @param [type] $user_id

     * @return void

     */

    public function getListOfDeclarationByUserIdAndSeperateByType($user_id, $user_period_ids = [])

    {

        $declaration = Declaration::selectRaw('SUM(`total_m2`) AS total_m2,SUM(declarations.`weight`) as total_weight,

        declarations.`unit_price` as total_unit_price,

        SUM(`total`) as total_of_total,

        SUM(`btw`) as total_btw,

        SUM(`total_btw`) as total_of_total_btw,

        SUM(`pro_nl`) as total_pro_nl,

        SUM(`imp_be`) as total_imp_be,

        SUM(`imp_de`) as total_imp_de,

        SUM(`imp_po`) as total_imp_po,

        SUM(`imp_turk`) as total_imp_turk,

        SUM(`import`) as total_import,

        type_id,declaration_types.name,declaration_types.minimum_validate,declaration_types.unit_price as type_unit_price'

        )

            ->join('declaration_types', 'declaration_types.id', '=', 'declarations.type_id')

            //->join('categories','categories.id','=','declaration_types.category_id')

            ->where('declarations.user_id', $user_id)

            ->whereIn('declarations.user_period_id', $user_period_ids)

            ->where('declarations.status', 1)

            ->groupBy(['type_id'])

            ->orderBy('declaration_types.sort', 'asc')// phmd

            ->get();

        return $declaration;

    }



    public function getListOfDeclarationByUserIdAndSeperateByTypeOld($user_id, $user_period_ids = [])

    {

        $declaration = Declaration::selectRaw('SUM(`total_m2`) AS total_m2,SUM(declarations.`weight`) as total_weight,

        declarations.`unit_price` as total_unit_price,

        SUM(`total`) as total_of_total,

        SUM(`btw`) as total_btw,

        SUM(`total_btw`) as total_of_total_btw,

        SUM(`pro_nl`) as total_pro_nl,

        SUM(`imp_be`) as total_imp_be,

        SUM(`imp_de`) as total_imp_de,

        SUM(`imp_po`) as total_imp_po,

        SUM(`imp_turk`) as total_imp_turk,

        SUM(`import`) as total_import,

        type_id,declaration_types.name,declaration_types.minimum_validate,declaration_types.unit_price as type_unit_price'

        )

            ->join('declaration_types', 'declaration_types.id', '=', 'declarations.type_id')

            //->join('categories','categories.id','=','declaration_types.category_id')

            ->where('declarations.user_id', $user_id)

            ->whereIn('declarations.user_period_id', $user_period_ids)

            ->where('declarations.status', 1)

            ->groupBy(['type_id'])

            ->get();

        return $declaration;

    }



    /**

     * Get declaration by user id and quater name with seperate by declaration type

     *

     * @param [type] $user_id

     * * @param [type] $user_id

     * @return void

     */

    public function getListOfDeclarationQuaterSix($user_id, $period_id)

    {

        $declaration = Declaration::selectRaw('declaration_types.name as type_name,categories.title as category_name, declarations.*')

            ->join('declaration_types', 'declaration_types.id', '=', 'declarations.type_id')

            ->join('categories', 'categories.id', '=', 'declaration_types.category_id')

            ->where('declarations.user_id', $user_id)

            ->where('declarations.status', 1)

            ->where('declarations.user_period_id', $period_id)

            ->orderBy('declaration_types.sort', 'asc')// phmd

            ->get();

        return $declaration;

    }



    public function getListOfDeclarationQuaterSixOld($user_id, $period_id)

    {

        $declaration = Declaration::selectRaw('declaration_types.name as type_name,categories.title as category_name, declarations.*')

            ->join('declaration_types', 'declaration_types.id', '=', 'declarations.type_id')

            ->join('categories', 'categories.id', '=', 'declaration_types.category_id')

            ->where('declarations.user_id', $user_id)

            ->where('declarations.status', 1)

            ->where('declarations.user_period_id', $period_id)

            ->get();

        return $declaration;

    }

}

