<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DeclarationTemp extends Model
{
    protected $table = "declaration_temps";

    protected $fillable = [
        'user_period_id','user_id', 'type_id', 'total_m2', 'period_id',
        'unit_price', 'total', 'btw', 'total_btw',
        'place', 'date', 'name', 'phone',
        'ready', 'email_sent', 'reminder', 'pro_nl', 'imp_be', 'imp_po', 'imp_de', 'imp_turk',
        'import', 'weight', 'admin_id'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'created_at' => 'timestamp',
        'updated_at' => 'timestamp',
        'date' => 'datetime'
    ];


    public function getListFilled($id){
        $query = $this->where('user_id', $id)
            ->join('periods', 'periods.id', '=', 'declarations.period_id')
            ->selectRaw("
                periods.type,
                periods.period,
                periods.description,
                declarations.id
            ")
            ->orderBy('periods.id', 'desc');

        return $query->get();
    }

    public function getListForAdmin(){
        $query = $this->join('periods', 'periods.id', '=', 'declarations.period_id')
            ->join('users', 'users.id', '=', 'declarations.user_id')
            ->selectRaw("
                periods.period,
                periods.type,
                periods.description,
                declarations.id,
                users.user_name
            ")
            ->where('declarations.type_id', '<>', AppConstant::DEC_TYPE_NULL)
            ->orderBy("periods.id", 'desc');

        return $query->paginate(config('appvalue.paging'));
    }

    public function deleteDetailDeclarationTemp($user_period_id){
        $result = DeclarationTemp::where('user_period_id',$user_period_id)->delete();

        return $result;
    }

    public function checkDeclarationTempOfUser($user_id){
        $result = DeclarationTemp::where('user_id',$user_id)->get();

        return $result;
    }



}
