<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Period extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'period',
        'type',
        'description',
        'group_period',
        'date_statement',
        'date_release',
        'date_start'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'date_statement' => 'datetime',
        'date_release' => 'datetime',
        'date_start' => 'datetime',
        'date_end' => 'datetime'
    ];

    public function getListUnfill($id)
    {
        $query = $this->leftJoin('declarations', function ($query) use ($id) {
            $query->on('declarations.period_id', '=', 'periods.id')
                ->where('declarations.user_id', '=', $id);
        })
            ->selectRaw("
                periods.id,
                periods.period,
                periods.type,
                periods.description,
                periods.date_release,
                declarations.id as dec_id
            ");
        $list = $query->get();
        $result = [];
        if (count($list) > 0) {
            foreach ($list as $item) {
                if (empty($item->dec_id)) {
                    $result[] = $item;
                }
            }
        }

        return $result;
    }

    public function getListForAdmin()
    {
        return Period::orderBy("period", "desc")->paginate(config('appvalue.paging'));
    }

    public function getPeriod($period_id)
    {
        $period = Period::where("import_id", "=", $period_id)->first();
        return $period;
    }
    /**
     * get period details by period id
     */
    public function getPeriodDetailsById($periodId)
    {
        $periodDetails = Period::find($periodId)->firstOrFail();
        return $periodDetails;
    }

    /**
     * Get Period of year
     *
     * @param [string] $year
     * @return Eloquent
     */
    public function getPeriodByYear($year)
    {
        $period = Period::selectRaw('*')
            ->where('periods.period', "like", "%Q6%")
            ->where('periods.group_period', "=", $year)
            ->first();
        return $period;
    }

     
    
}
