<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\DB;
use App\Models\UserOld;
use Illuminate\Support\Facades\Hash;
use App\Models\PeriodOld;
use App\Models\Period;
use App\Models\DeclarationOld;
use App\Models\DeclarationNew;
use App\Models\Declaration;
use App\Models\UserPeriod;
use App\Mail\CreateUser;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;

class User extends Authenticatable
{
    use Notifiable;

    const STATUS_ACTIVE = 1;
    const STATUS_INACTIVE = 0;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_name', 'password', 'admin_process',
        'first_name', 'last_name', 'email', 'active',
        'oav_number', 'company_name', 'address', 'postcode',
        'place', 'land', 'phone', 'fax', 'kvk_number', 'btw_number','forgot_code','import_id'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'oav_date' => 'datetime'
    ];

    public function getUserActive(){
        $query = $this->leftJoin('user_updates', function ($query){
                $query->on('user_updates.user_id', '=', 'users.id')
                    ->where('user_updates.status', '=', UserUpdate::STATUS_PENDING);
            })
            ->selectRaw("
                users.id,
                users.email,
                users.user_name,
                users.oav_number,
                users.company_name,
                users.address,
                users.active,
				users.start_date,
                users.end_date,
                user_updates.id as u_id
            ");

        /* return $query->paginate(config('appvalue.paging')); */
        return $query->get();
    }
    public function getCountUser()
    {
        $listUser = User::selectRaw('users.id')->get();
        return $listUser;
    }
    public function getRequestEditUser(){
        $query = $this->join('user_updates', function ($query){
                $query->on('user_updates.user_id', '=', 'users.id')
                    ->where('user_updates.status', '=', UserUpdate::STATUS_PENDING);
            })
            ->selectRaw("
                users.id,
                users.email,
                users.user_name,
                users.oav_number,
                users.company_name,
                users.address,
                users.active,
                user_updates.id as u_id,
                user_updates.created_at as date_request
            ");
        return $query->get();
    }

    /**
     * update user first login time
     */
    public function updateUserLoginFirstTime($userId){
        $userDetails = User::where("id","=",$userId)->firstOrFail();
        $userDetails->is_first_time = 1;
        $userDetails->save();
        return $userDetails;
    }

    /**
     * get user details by user id
     */
    public function getUserDetailsById($userId){
        $userDetails = User::where("id","=",$userId)->firstOrFail();
        return $userDetails;
    }

    /**
     * Get Users have not madet Made declaration yet
     *
     * @return void
     */
    public function getUserNotDeclaration($period_id){
        $period = Period::where("id","=",$period_id)->first();
        $type_period    = $period->type;
        $group_period   = $period->group_period;
        $periodQ        = $period->period;
        $current_year   = date("Y");
        $current_month  = date("m");

        $queryWhere = "users.id not in (select user_id from user_periods where period_id = '$period_id')";		$allow_month = [];

        if( $type_period == 1 ){
            $Qs = explode('Q', $periodQ );
            $Q = end( $Qs );
            switch ($Q) {
                case '1':
                    $allow_month = [1,2,3];/*1 2 3*/
					$greater_month = 1;
                    break;
                case '2':
                    $allow_month = [1,2,3,4,5,6];/*4 5 6*/
					$greater_month = 4;
                    break;
                case '3':
                    $allow_month = [1,2,3,4,5,6,7,8,9];/*7 8 9*/
					$greater_month = 7;
                    break;
                case '4':
                    $allow_month = [1,2,3,4,5,6,7,8,9,10,11,12];/*10 11 12*/
					$greater_month = 10;
                    break;
                default:
                    $allow_month = [];
                    break;
            }
			$queryWhere .= " AND users.period_type = '$type_period' ";
            $queryWhere .= " AND YEAR(users.start_date) <= ".$group_period;
			$queryWhere .= " AND YEAR(users.end_date) >= ".$group_period;
            $queryWhere .= " AND MONTH(users.end_date) >= ".$greater_month;
        }
        if( $type_period == 2 ){
            /* Q5 */
			$queryWhere .= " AND users.period_type = '$type_period' ";
            $queryWhere .= " AND YEAR(users.end_date) >= ".$group_period;
        }
         if( $type_period == 3 ){
            /* Q6 */
            //$queryWhere .= " AND YEAR(users.start_date) <= ".( $group_period - 1 );
            $queryWhere .= " AND YEAR(users.start_date) <= ".( $group_period );
            //$queryWhere .= " AND YEAR(users.end_date) > ".( $group_period );
			$queryWhere .= " AND YEAR(users.end_date) >= ".( $group_period );
        }
        if( $type_period == 4 ){
            // MONTHLY (MAAND) LOGIC
            // Extract month from periodQ (format YYYY-MM)
            $parts = explode('-', $periodQ);
            $periodYear  = isset($parts[0]) ? (int)$parts[0] : (int)$group_period;
            $periodMonth = isset($parts[1]) ? (int)$parts[1] : (int) date('m');

            $allow_month = [$periodMonth]; // Only this month allowed

            $queryWhere .= " AND users.period_type = '$type_period' ";
            $queryWhere .= " AND YEAR(users.start_date) <= ".$periodYear;
            $queryWhere .= " AND YEAR(users.end_date) >= ".$periodYear;
            $queryWhere .= " AND MONTH(users.end_date) >= ".$periodMonth;
        }


        $builderUser = User::selectRaw('DISTINCT users.id,users.user_name,users.oav_number,users.company_name,users.email,users.address,user_periods.status,user_periods.period_id,users.start_date,users.end_date,users.period_type')
                        ->leftJoin('user_periods','user_periods.user_id','=','users.id')
                        ->whereRaw($queryWhere)
                        ->groupBy('users.id','users.user_name','users.oav_number','users.company_name','users.email','users.address','user_periods.status')
                        ->orderBy('users.start_date','DESC')
                        ->get()->unique();

        foreach ($builderUser as $key => $value) {

            // Allow users with no valid start_date
            if ($value->start_date == '0000-00-00' || $value->start_date == null) {
                continue;
            }

            $user_year  = (int)date('Y', strtotime($value->start_date));
            $user_month = (int)date('m', strtotime($value->start_date));

            if ($user_year == $current_year && !in_array($user_month, $allow_month)) {
                unset($builderUser[$key]);
            }
        }


        return $builderUser;
    }
    public function getUserNotDeclarationBK($period_id){
        //Need param $period_id
        $current_year = date("Y");
        $period = Period::where("id","=",$period_id)->first();
        $type_period = $period->type;

        $list_id = "";
        $queryWhere = "";
        if($type_period == 2){
            $list_period = Period::where("group_period","=",$current_year)->get();
            $count_list_period = count($list_period);
            $list_id = "";
            $i = 0;
            foreach($list_period as $_period){
                $list_id .= $_period->id;
                if($i < $count_list_period - 1){
                    $list_id.=",";
                }
                $i++;
            }
            $queryWhere = "users.id not in (select user_id from user_periods where period_id = '$period_id') and period_type = '$type_period'";
        }
        if($type_period == 1){
            $list_period = Period::where("group_period","=",$current_year)->where("type","=",2)->get();
            $count_list_period = count($list_period);
            $list_id = "";
            $i = 0;
            foreach($list_period as $_period){
                $list_id .= $_period->id;
                if($i < $count_list_period - 1){
                    $list_id.=",";
                }
                $i++;
            }
            $list_id .= ",".$period_id."";
            $queryWhere = "users.id not in (select user_id from user_periods where period_id = '$period_id') and period_type = '$type_period'";
        }
        if($type_period == 3){
            $current_year = $period->group_period;
            $list_period = Period::where("group_period","=",$current_year)->where("type","=",3)->get();
            $count_list_period = count($list_period);
            $list_id = "";
            $i = 0;
            foreach($list_period as $_period){
                $list_id .= $_period->id;
                if($i < $count_list_period - 1){
                    $list_id.=",";
                }
                $i++;
            }
            $queryWhere = "users.id not in (select user_id from user_periods where period_id = '$period_id')";
        }
        $builderUser = User::selectRaw('DISTINCT users.id,users.user_name,users.oav_number,users.company_name,users.email,users.address,user_periods.status')
                        ->leftJoin('user_periods','user_periods.user_id','=','users.id')
                        /*->whereRaw('users.id not in (select user_id from user_periods where period_id in ('.$list_id .'))')*/
                        /*->whereRaw("users.id not in (select user_id from user_periods where period_id = '$period_id') and period_type = '$type_period'")*/
                        ->whereRaw($queryWhere)
                        ->groupBy('users.id','users.user_name','users.oav_number','users.company_name','users.email','users.address','user_periods.status')
                        ->get()->unique();
        return $builderUser;
    }

    public function importPeriod()
    {
        $period_old = new PeriodOld();
        $list_period_old_list = $period_old->getListPeriod();
        foreach($list_period_old_list as $_period_old){
            $period = new Period();
            $type_old = $_period_old->type;
            $period->period = $_period_old->tijdvak;
            if($type_old == "kwartaal"){
                $period->type = 1;
            }
            if($type_old == "jaar"){
                $period->type = 2;
            }
            $period->description = $_period_old->omschrijving;
            $period->date_statement  = $_period_old->datum_opgave;
            $period->date_release = $_period_old->datum_vrijgave;
            $period->date_start  = $_period_old->datum_start;
            $period->import_id   = $_period_old->id_periode;
            $period->save();
        }
    }
    public function getUser($user_import_id)
    {
        $user = User::where("import_id","=",$user_import_id)->first();
        return $user;
    }
    public function importInvoice()
    {
        //user_period id
        //declaration old
        set_time_limit(0);
        $declaration_old = new DeclarationOld();
        $list_declaration_old = $declaration_old->getListDeclarationOld();
        foreach($list_declaration_old as $_invoice){
            $declaration = new Declaration();
            $dec_id_old = $_invoice->id_aangifteoud;
            $dec_user_id_old = $_invoice->id_feuser;
            $dec_period_id_old = $_invoice->id_periode;

            $dec_status_old = $_invoice->aangifte;
            $dec_type = 5;
            $unit_price = "0.30";
            $total = $_invoice->bijdrage;
            $btw = $_invoice->btw;
            $total_btw = $_invoice->bijdragebtw;
            $place = $_invoice->plaats;
            $date = $_invoice->datum;
            $name = $_invoice->naam;
            $phone = $_invoice->telefoon;
            $ready = $_invoice->gereed;
            $email_sent = $_invoice->email_verstuurd;
            $weight = floatval($_invoice->gewicht);
            $pro_nl = floatval($_invoice->pro_nl);
            $imp_be = floatval($_invoice->imp_be);
            $imp_de  = floatval($_invoice->imp_de);
            $imp_po  = floatval($_invoice->imp_po);
            $imp_turk  = floatval($_invoice->imp_turk);
            $import  = floatval($_invoice->import);
            $total_m2 = $pro_nl + $imp_be + $imp_de + $imp_po + $imp_turk + $import;

            $userModel = new User();
            $user = $userModel->getUser($dec_user_id_old);
            if($user != null){
                $user_id_new = $user->id;
            }else{
                continue;
            }
            //$name = $user->company_name;
            //$place = $user->place;
            //$phone = $user->phone;
            $user_period = new UserPeriod();
            $tempPeriod = $user_period->getUserPeriod($dec_user_id_old,$dec_period_id_old);

            $periodModel = new Period();
            $period = $periodModel->getPeriod($dec_period_id_old);
            $user_period_id = "";
            if($tempPeriod == null){
                //user period ra
                //'user_id', 'period_id', 'status', 'name', 'c', 'phone', 'admin_updated_at','user_import_id','period_import_id'
                $user_period->user_id = $user_id_new;
                if($period != null){
                    $user_period->period_id = $period->id;
                }else{
                    $user_period->period_id = $dec_id_old;
                }
                $user_period->status = $dec_status_old;
                $user_period->name = $name;
                $user_period->place = $place;
                $user_period->phone = $phone;
                $user_period->user_import_id = $dec_user_id_old;
                $user_period->period_import_id = $dec_period_id_old;
                $user_period->save();
                $user_period_id = $user_period->id;
            }else{
                $user_period_id = $tempPeriod->id;
            }
            //Insert Invoice
            /*'user_period_id','user_id','type_id', 'total_m2', 'period_id',
            'unit_price', 'total', 'btw', 'total_btw',
            'place', 'date', 'name', 'phone',
            'ready', 'email_sent', 'reminder', 'pro_nl', 'imp_be', 'imp_po', 'imp_de',
            'import', 'weight', 'admin_id'*/
            $declaration->user_period_id = $user_period_id;
            $declaration->user_id = $user_id_new;
            $declaration->type_id = $dec_type;
            $declaration->total_m2 = $total_m2;
            $declaration->unit_price = $unit_price;
            $declaration->total = $total;
            $declaration->btw = $btw;
            $declaration->total_btw = $total_btw;
            $declaration->place = $place;
            $declaration->date = $date;
            $declaration->name = $name;
            $declaration->phone = $phone;
            $declaration->ready = $ready;
            $declaration->email_sent = $email_sent;
            $declaration->weight = $weight;
            $declaration->pro_nl = $pro_nl;
            $declaration->imp_be = $imp_be;
            $declaration->imp_de = $imp_de;
            $declaration->imp_po = $imp_po;
            $declaration->imp_turk = $imp_turk;
            $declaration->import = $import;
            $declaration->status = 1;
            $declaration->save();
        }
    }
    public function updateUser()
    {
        $user_old = new UserOld();
        $list_user_old = $user_old->getListUserOld();
        $i = 0;
        foreach($list_user_old as $_user_old){
            $password_init = $_user_old->password_init;
            $user_import_id = $_user_old->id;
            $user = User::where("import_id","=",$user_import_id)->first();
            $user->password_init = $password_init;
            $user->save();
        }
    }
    public function updatePeriodUser()
    {
        $user_old = new UserOld();
        $list_user_old = $user_old->getListUserOld();
        $i = 0;
        foreach($list_user_old as $_user_old){
            $period = $_user_old->Aangifteperiode;
            $user_import_id = $_user_old->id;
            $user = User::where("import_id","=",$user_import_id)->first();
            $user->period = $period;
            $type = 1;
            if($period == "Jaar"){
                $type = 2;
            }
            $user->period_type = $type;
            $user->save();
        }
    }
    public function updateInvoice()
    {
        set_time_limit(0);
        $declaration_old = new DeclarationOld();
        $list_declaration_old = $declaration_old->getListDeclarationOld();
        foreach($list_declaration_old as $_invoice){
            $dec_user_id_old = $_invoice->id_feuser;
            $dec_period_id_old = $_invoice->id_periode;

            $unit_price = $_invoice->verwijderingsbijdrage / 100;
            $total = $_invoice->bijdrage / 100;
            $btw = $_invoice->btw / 100;
            $total_btw = $_invoice->bijdragebtw / 100;


            $user_period = new UserPeriod();
            $tempPeriod = $user_period->getUserPeriodByImportId($dec_user_id_old,$dec_period_id_old);
            if($tempPeriod != null){
                $user_period_id = $tempPeriod->id;
                $declarationModel = new Declaration();
                $declaration = $declarationModel->getDeclarationByUserPeriodId($user_period_id);
                $declaration->unit_price = $unit_price;
                $declaration->total = $total;
                $declaration->btw = $btw;
                $declaration->total_btw = $total_btw;
                $declaration->save();
            }else{
                echo "NOT FOUND user_period_id".$dec_period_id_old." AND user_id ".$dec_user_id_old."</br>";
            }
        }
    }
    public function importUser()
    {
        $user_old = new UserOld();
        $list_user_old = $user_old->getListUserOld();
        //var_dump($list_user_old);
        $i = 0;
        $arrayResult = array();
        $count_for_update = 0;
        $count_for_new = 0;
        foreach($list_user_old as $_user_old){
            $password_init = $_user_old->password_init;
            $period = $_user_old->Aangifteperiode;
            $contact_persoon = $_user_old->Contactpersoon_OAV_volledig;
            $oav_number = $_user_old->OAV_Nr;
            $user = User::where("oav_number","=",$oav_number)->first();
            if($user == null){
                $user = new User();
                $user->user_name = $_user_old->OAV_Nr;
                $user->is_first_time = 1;
                $new_pw= Str::random(10);
                $user->password = Hash::make($new_pw);
                //$user->password_init = $password_init;

                Mail::to(str_replace(" ", "", $_user_old->OAV_E_Mail_Adres))->send(new CreateUser($user->user_name, $new_pw));

                $count_for_new++;
            }else{
                $count_for_update++;
            }
            /*
            last_name
            */
            $user->first_name = $_user_old->Contactpersoon_OAV_volledig;
            $user->email = $_user_old->OAV_E_Mail_Adres;
            $user->oav_number = $_user_old->OAV_Nr;
            $user->company_name = $_user_old->Bedrijfsnaam;
            $user->address = $_user_old->Adres;
            $user->postcode = $_user_old->Postcode;
            $user->place = $_user_old->Plaats;
            $user->land = $_user_old->Land_regiocode;
            $user->phone = $_user_old->Telefoon;
            $user->fax = $_user_old->Fax;
            $user->kvk_number = $_user_old->Kamer_van_Koophandel;
            $user->btw_number = $_user_old->BTW_nummer;
            $user->start_date = $_user_old->Oav_ingangsdatum;
            $user->end_date = $_user_old->Oav_einddatum;
            $user->OAV_Einddatum = $_user_old->Oav_einddatum;
            $user->electronischafval = ( $_user_old->Electronica == 'Ja' ) ? 1: 0;
            $user->glasafval = ( $_user_old->Glass == 'Ja' ) ? 1: 0;;
            $user->active = 1;

            $user->period = $period;
            $user->contact_persoon = $contact_persoon;
            $type = 1;
            if($period == "Jaar"){
                $type = 2;
            }
            $user->period_type = $type;
            $user->save();
        }
        $arrayResult["count_for_update"] = $count_for_update;
        $arrayResult["count_for_new"] = $count_for_new;
        return $arrayResult;
    }
}
