<?php

namespace App\Models;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;

class UserUpdate extends Model
{
    const STATUS_PENDING = 0;
    const STATUS_ACCEPTED = 1;
    const STATUS_REJECTED = 2;
    const STATUS_OVERRIDE = 3;

    protected $fillable = [
        'company_name', 'address', 'postcode', 'user_id',
        'place', 'land', 'phone', 'fax', 'kvk_number', 'btw_number', 'status', 'contact','email'
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'oav_date' => 'datetime'
    ];

    public function requestUpdate($userId, $data){
        $this->where('user_id', $userId)
            ->where('status', self::STATUS_PENDING)
            ->update([
                'status' => self::STATUS_OVERRIDE
            ]);

        $this->create([
            'user_id' => $userId,
            'company_name' => empty($data['company_name']) ? null : $data['company_name'],
            'email' => empty($data['email']) ? null : $data['email'],
            'address' => empty($data['address']) ? null : $data['address'],
            'postcode' => empty($data['postcode']) ? null : $data['postcode'],
            'place' => empty($data['place']) ? null : $data['place'],
            'land' => empty($data['land']) ? null : $data['land'],
            'phone' => empty($data['phone']) ? null : $data['phone'],
            'fax' => empty($data['fax']) ? null : $data['fax'],
            'kvk_number' => empty($data['kvk_number']) ? null : $data['kvk_number'],
            'btw_number' => empty($data['btw_number']) ? null : $data['btw_number'],
			'contact' => empty($data['contact_persoon']) ? null : $data['contact_persoon'],
            /*'declaration_type' => empty($data['declaration_type']) ? null : $data['declaration_type'],
            'declaration_web' => empty($data['declaration_web']) ? null : $data['declaration_web'],
            'contact' => empty($data['contact']) ? null : $data['contact'],
            'oav_date' => empty($data['oav_date']) ? null : $data['oav_date'],*/
        ]);


        return true;
    }
}
