<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDeclarationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('declarations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('user_period_id');
            $table->bigInteger('type_id')->default(0);
            $table->decimal('total_m2')->nullable();
            $table->decimal('unit_price')->nullable();
            $table->decimal('total')->nullable();
            $table->decimal('btw')->nullable();
            $table->decimal('total_btw')->nullable();
            $table->string('place', 255)->nullable();
            $table->dateTime('date')->nullable();
            $table->string('name', 255)->nullable();
            $table->string('phone')->nullable();
            $table->tinyInteger('ready')->nullable();
            $table->tinyInteger('email_sent')->nullable();
            $table->tinyInteger('reminder')->nullable();
            $table->decimal('pro_nl')->nullable();
            $table->decimal('imp_be')->nullable();
            $table->decimal('imp_de')->nullable();
            $table->decimal('imp_po')->nullable();
            $table->decimal('import')->nullable();
            $table->decimal('weight')->nullable();
            $table->smallInteger('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('declarations');
    }
}
