@extends('layouts.color_admin.default')
@section('title', 'Beheerders')

@section('content')
    <div class="a-page-content">
        <div class="normal-table-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="normal-table-list">
                            <div class="basic-tb-hd a-header-content">
                                <h2>Beheerders</h2>
                                <p>Totaal: {{ $list->total() }}</p>
                                <a href="{{ route('admin.admin.update' ,['id' => 0]) }}" class="btn btn-primary btn-sm a-style-btn-crt">
                                    Beheerder Aanmaken
                                </a>
                            </div>
                            <div class="bsc-tbl">
                                <table class="table table-striped table-sc-ex">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Username</th>
                                        <th>E-mail</th>
                                        <th>Rol</th>
                                        <th></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($list as $key => $item)
                                        <tr>
                                            <td>{{ ($list->currentPage() - 1) * config('appvalue.paging') + $key + 1 }}</td>
                                            <td>{{ $item->user_name }}</td>
                                            <td>{{ $item->email }}</td>
                                            <td>{{ !empty($listRole[$item->role]) ? $listRole[$item->role] : "N/A" }}</td>
                                            <td>
                                                @if($item->id != $owner->id)
                                                    <span class="btn btn-sm btn-danger delete-ad" data-id="{{$item->id}}">Verwijderen</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="5" class="text-center">Geen data.</td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row mt-5">
                    <div class="col-12">
                        <div style="padding-left: 15px">
                            {{ $list->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
    $(function () {
        let _page = $('.a-page-content');

        _page.on('click', '.delete-ad', function () {
            let _confirm = confirm("Delete selected admin?");
            if(_confirm){
                let _data = {
                    id: $(this).attr('data-id')
                };
                $.ajax({
                    url: "{{ route('admin.admin.delete') }}",
                    type: "POST",
                    data: _data
                }).done(function(res) {
                    if(res.status == 'success'){
                        alert('delete admin is successful');
                        window.location = location.href;
                    }
                });
            }
        })
    });
</script>
@endpush

