@extends('layouts.color_admin.default')
@section('title', 'Beheerders')


@section('content')
    <div class="a-page-content">
        <div class="breadcomb-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="breadcomb-list">
                            <form method="post" action="{{ route('admin.admin.store') }}">
                                @csrf
                                <div class="row">
                                    <div class="col-12" style="padding-left: 30px">
                                        @if(empty($admin->id))
                                            <h3>Beheerder maken</h3>
                                        @else
                                            <h3>Beheerder bijwerken</h3>
                                        @endif
                                    </div>
                                </div>
                                <input type="hidden" name="id" value="{{ !empty($admin->id) ? $admin->id : 0 }}">
                                <div class="row">
                                    <div class="col-md-2 col-12 text-center a-mt-15">
                                        <span class="a-title-adjust">Naam</span>
                                    </div>
                                    <div class="col-12 col-md-4 has-error a-mt-15">
                                        <input type="text" class="form-control" name="user_name" value="{{ old('user_name') }}" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-2 col-12 text-center a-mt-15">
                                        <span class="a-title-adjust">E-mail</span>
                                    </div>
                                    <div class="col-12 col-md-4 has-error a-mt-15">
                                        <input type="text" class="form-control" name="email" value="{{ old('email') }}" required>
                                    </div>
                                </div>
                                <div class="row a-mt-15">
                                    <div class="col-md-2 col-12 text-center a-mt-15"></div>
                                    <div class="col-md-4 text-right col-12">
                                        <button class="btn btn-primary btn-sm">Verzenden</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(function () {
            let _page = $('.a-page-content');
            var pathname = window.location.pathname;
            var menuItem = $('a[href="/admin/manager"]').closest('li');
			menuItem.addClass('active');
            menuItem.closest('li.has-sub').addClass('active');
        });
    </script>
@endpush
