@extends('layouts.color_admin.default')
@section('title', 'Types')

@section('content')
    <div class="a-page-content">
        <div class="normal-table-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="normal-table-list xdev-table">
                            <div class="basic-tb-hd a-header-content">
                                <h2>Aangiftetype</h2>
                                <p>Totaal: {{ count($list) }}</p>
                                <a href="{{ route('admin.dec.updateDecType', ['id' => 0]) }}" class="btn btn-primary btn-sm a-style-btn-crt">
                                    Reststroom aanmaken
                                </a>
                            </div>
                            @if(Session::has('b_a_message'))
                                <div class="row mt-3 mb-4">
                                    <div class="col-12">
                                        <div class="alert alert-success">
                                            {{ Session::pull('b_a_message')}}
                                        </div>
                                    </div>
                                </div>
                            @endif
                            <div class="table-responsive">
                                <table id='data-table' class="table table-sc-ex">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Soort</th>
                                        <th>Categorie</th>
                                        <th>Stuksprijs</th>
                                        <th>Gewicht</th>
                                        <th>Soort( <2022)</th>
                                        <th>Soort ( >2022)</th>
                                        <th>Toestand</th>
                                        <th></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($list as $key => $item)
                                        <tr>
                                            <td>{{ $key + 1}}</td>
                                            <td>{{ $item->name }}</td>
                                            <td>{{ $item->title }}</td>
                                            <td>{{ $item->unit_price }}</td>
                                            <td>{{ $item->weight }}</td>
                                            <td>{{ $item->old_sort }} </td>
                                            <td>{{ $item->sort }}</td>
                                            <td>{{ $item->is_deleted == \App\Helper\AppConstant::IS_DELETED ? 'Verwijderd' : 'Actief' }}</td>
                                            <td>
                                                <a href="{{ route('admin.dec.updateDecType', ['id' => $item->id]) }}" class="btn btn-sm btn-primary">Bijwerken</a>
                                                <?php /*if(empty($item->is_deleted)){ ?>
                                                    <a href="{{ route('admin.dec.deleteDecType', ['id' => $item->id]) }}" class="btn btn-sm btn-danger">Verwijderen</a>
                                                <?php }*/ ?>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="5" class="text-center">Geen data.</td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                {{-- <div class="row mt-5">
                    <div class="col-12">
                        <div style="padding-left: 15px">
                            {{ $list->links() }}
                        </div>
                    </div>
                </div> --}}
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(function () {
            var pathname = window.location.pathname;
            var menuItem = $('a[href="/admin/maList"]').closest('li');
			menuItem.addClass('active');
            menuItem.closest('li.has-sub').addClass('active');

            $("#data-table").DataTable({
                'paging': true,
                "pagingType": "simple_numbers",
                'lengthChange': true,
                'searching': true,
                'info': true,
                'autoWidth': false,
                'stateSave': true,
                "language": {
                    "decimal":        "",
                    "emptyTable":     "Geen data beschikbaar in de tabel",
                    "info":           "Toon _START_ tot _END_ van _TOTAL_ items",
                    "infoEmpty":      "Toon 0 van 0 van 0 items",
                    "infoFiltered":   "(gefilterd uit _MAX_ totaal inzendingen)",
                    "infoPostFix":    "",
                    "thousands":      ",",
                    "lengthMenu":     "Toon _MENU_ items",
                    "loadingRecords": "Bezig met laden...",
                    "processing":     "Verwerken...",
                    "search":         "Zoeken:",
                    "zeroRecords":    "Geen overeenkomende records gevonden",
                    "paginate": {
                        "first":      "Eerste",
                        "last":       "Laatste",
                        "next":       "Volgende",
                        "previous":   "Vorige"
                    },
                    "aria": {
                        "sortAscending":  ": activeren om kolom oplopend te sorteren",
                        "sortDescending": ": activeren om kolom aflopend te sorteren"
                    }
                }
            });

            /* let _page = $('.a-page-content'); */
        });
    </script>
@endpush
