@extends('layouts.color_admin.default')
@section('title', "Declaration's Type")


@section('content')
    <div class="a-page-content">
        <div class="breadcomb-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="breadcomb-list">
                            <form method="post" action="{{ route('admin.dec.storeDecType') }}">
                                @csrf
                                <div class="row">
                                    <div class="col-12" style="padding-left: 30px">
                                        @if(empty($decType->id))
                                            <h3>Maken</h3>
                                        @else
                                            <h3>Bijwerken</h3>
                                        @endif
                                    </div>
                                </div>

                                @if ($errors->any())
                                    <div class="row mt-3 mb-3">
                                        <div class="col-12">
                                            <div class="alert alert-danger">
                                                <ul style="margin-bottom: 0">
                                                    @foreach ($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                <input type="hidden" name="id" value="{{ !empty($decType->id) ? $decType->id : 0 }}">
                                <div class="row">
                                    <div class="col-md-2 col-12 text-center a-mt-15">
                                        <span class="a-title-adjust">Soort</span>
                                    </div>
                                    <div class="col-12 col-md-4 a-mt-15">
                                        <input type="text" class="form-control" name="name" value="{{ old('name', $decType->name) }}" required>
                                    </div>
                                </div>

                                {{-- show list categories --}}
                                <div class="row">
                                    <div class="col-md-2 col-12 text-center a-mt-15">
                                        <span class="a-title-adjust">Categorie</span>
                                    </div>
                                    <div class="col-12 col-md-4 a-mt-15">
                                        <select name="category_id" id="category_id" class="form-control">
                                            @foreach ($categories as $ctg)
                                                @if (old('category_id',$decType->category_id) == $ctg->id)
                                                    <option value="{{$ctg->id}}" selected>{{$ctg->title}}</option>
                                                @else
                                                    <option value="{{$ctg->id}}">{{$ctg->title}}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                     </div>
                                </div>
                                {{-- show list categories --}}

                                <div class="row">
                                    <div class="col-md-2 col-12 text-center a-mt-15">
                                        <span class="a-title-adjust">Prijs</span>
                                    </div>
                                    <div class="col-12 col-md-4 has-error a-mt-15">
                                        <input type="number" step=".01" class="form-control" name="unit_price" value="{{ old('unit_price', $decType->unit_price) }}" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-2 col-12 text-center a-mt-15">
                                        <span class="a-title-adjust">Gewicht</span>
                                    </div>
                                    <div class="col-12 col-md-4 has-error a-mt-15">
                                        <input type="number" class="form-control" name="weight" value="{{ old('weight', $decType->weight) }}" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-2 col-12 text-center a-mt-15">
                                        <span class="a-title-adjust">Soort ( < 2022)</span>
                                    </div>
                                    <div class="col-12 col-md-4 a-mt-15">
                                        <input type="number" min="0" step="1" class="form-control" name="old_sort" value="{{ old('old_sort', $decType->old_sort) }}">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-2 col-12 text-center a-mt-15">
				<span class="a-title-adjust">Soort ( > 2022)</span>
                                    </div>
                                    <div class="col-12 col-md-4 a-mt-15">
                                        <input type="number" min="0" step="1" class="form-control" name="sort" value="{{ old('sort', $decType->sort) }}">
                                    </div>
                                </div>
                                <div class="row a-mt-15">
                                    <div class="col-md-2 col-12 text-center a-mt-15"></div>
                                    <div class="col-12 col-md-4 has-error a-mt-15 text-right">
                                        @if(!empty($decType->id) && !empty($decType->is_deleted))
                                            <input type="hidden" value="1" name="is_deleted">
                                            <button class="btn btn-primary btn-sm">Actief</button>
                                        @else
                                            @if(!empty($decType->id))
                                                <a href="{{ route('admin.dec.deleteDecType', ['id' => $decType->id]) }}" class="btn btn-danger btn-sm">Verwijderen</a>
                                            @endif
                                            <button class="btn btn-primary btn-sm">Opslaan</button>
                                        @endif
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(function () {
            var pathname = window.location.pathname;
            var menuItem = $('a[href="/admin/maList"]').closest('li');
			menuItem.addClass('active');
            menuItem.closest('li.has-sub').addClass('active');

            let _page = $('.a-page-content');
        });
    </script>
@endpush
