@extends('layouts.color_admin.default')
@section('title', 'Moet Worden Bewerkt')
@push('css')
<link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet">
@endpush
@section('content')
    <div class="a-page-content">
        <div class="normal-table-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="normal-table-list xdev-table">
                            <div class="basic-tb-hd a-header-content">
                                <h2>Verzoek voor wijzigingen</h2>
                                <p>totaal: {{ count($list) }}</p>
                            </div>
                            <div class="table-responsive">
                                <table id="data-table" class="table table-sc-ex">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>OAV Nummer</th>
                                        <th>Bedrijfsnaam</th>
                                        <th>E-mail</th>
                                        <th>Adres</th>
										<td>Ingediend op</td>
                                        <th></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($list as $key => $item)
										<?php $date_created_at = strtotime($item->date_request);  ?>
										<?php $date_show = date("d/m/Y H:i:s",$date_created_at);  ?>
                                        @php
                                            $checked = "";
                                            if($item->active){
                                                $checked = "checked";
                                            }
                                        @endphp
                                        <tr>
                                            <td>{{ $key + 1  }}</td>
                                            <td>{{ $item->oav_number }}</td>
                                            <td>{{ $item->company_name }}</td>
                                            <td>{{ $item->email }}</td>
                                            <td>{{ $item->address }}</td>
											<td>{{$date_show}}</td>
                                            <td>
                                                <a href="{{ route('admin.home.viewRequest', ['id' => $item->id]) }}" class="btn btn-sm btn-danger">verzoek</a>
                                                <a href="{{ route('admin.home.detail', ['id' => $item->id]) }}" class="btn btn-sm btn-primary">Detail</a>
                                                <!--<input data-id="{{$item->id}}" class="toggle-class" type="checkbox" data-onstyle="success" data-offstyle="danger" data-toggle="toggle" data-on="Actief" data-off="Inactief" {{ $item->active ? 'checked' : '' }}>-->
                                            </td>
                                        </tr>
                                        @empty
                                            <tr>
                                                <td colspan="5" class="text-center">Geen data.</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>
    <script>
        $(function () {
            $("#data-table").DataTable({
                'paging': true,
                "pagingType": "simple_numbers",
                'lengthChange': true,
                'searching': true,
                'info': true,
                'autoWidth': false,
                'stateSave': true,
                "language": {
                    "decimal":        "",
                    "emptyTable":     "Geen data beschikbaar in de tabel",
                    "info":           "Toon _START_ tot _END_ van _TOTAL_ items",
                    "infoEmpty":      "Toon 0 van 0 van 0 items",
                    "infoFiltered":   "(gefilterd uit _MAX_ totaal inzendingen)",
                    "infoPostFix":    "",
                    "thousands":      ",",
                    "lengthMenu":     "Toon _MENU_ items",
                    "loadingRecords": "Bezig met laden...",
                    "processing":     "Verwerken...",
                    "search":         "Zoeken:",
                    "zeroRecords":    "Geen overeenkomende records gevonden",
                    "paginate": {
                        "first":      "Eerste",
                        "last":       "Laatste",
                        "next":       "Volgende",
                        "previous":   "Vorige"
                    },
                    "aria": {
                        "sortAscending":  ": activeren om kolom oplopend te sorteren",
                        "sortDescending": ": activeren om kolom aflopend te sorteren"
                    }
                }
            });

            var ajaxLoading = false;

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('input[name="csrf-token"]').val()
                }
            });

            $('.toggle-class').change(function() {
                var status = $(this).prop('checked') == true ? 1 : 0; 
                var user_id = $(this).data('id'); 
                
                if(ajaxLoading){
                    return;
                }
                ajaxLoading = true;
                $(".ajax-loading").addClass('show');

                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: '{{route("admin.home.changeActive")}}',
                    data: {'status': status, 'id': user_id},
                    success: function(data){
                        console.log(data)
                        if(data.status == 'success'){
                            ajaxLoading = false;
                            $(".ajax-loading").removeClass('show');
                        }
                    }
                });
            })
        });
    </script>
@endpush
