@extends('layouts.color_admin.default')
@section('title', 'Menu')

@section('content')
    <div class="a-page-content">
        <div class="normal-table-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="normal-table-list">
                            <div class="basic-tb-hd a-header-content">
                                <h2>Menu</h2>
                                <a href="{{ route('admin.menu.qa') }}" class="btn btn-primary btn-sm a-style-btn-crt">
                                    Vragen en antwoorden
                                </a>
                            </div>
                            <div class="bsc-tbl">
                                <table class="table table-sc-ex">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Naam</th>
                                        <th>Toestand</th>
                                        <th></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($list as $key => $item)
                                        <tr>
                                            <td>{{ $key + 1 }}</td>
                                            <td>{{ $item->display }}</td>
                                            <td>{{ $item->status == \App\Models\Menu::STATUS_HIDE ? 'Verbergen' : 'Tonen' }}</td>
                                            <td>
                                                @if($item->status == \App\Models\Menu::STATUS_HIDE)
                                                    <span class="btn btn-sm btn-primary btn-change-sts" data-id="{{ $item->id }}" data-status="{{ \App\Models\Menu::STATUS_SHOW }}">Tonen</span>
                                                @else
                                                    <span class="btn btn-sm btn-danger btn-change-sts" data-id="{{ $item->id }}" data-status="{{ \App\Models\Menu::STATUS_HIDE }}">Verbergen</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="5" class="text-center">Geen data.</td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(function () {
            let _page = $('.a-page-content');

            _page.on('click', '.btn-change-sts', function () {
                let _confirm = confirm("Wil je veranderen?");
                if(_confirm){
                    let _data = {
                        status: $(this).attr('data-status'),
                        id: $(this).attr('data-id')
                    };
                    $.ajax({
                        url: "{{ route('admin.menu.changeStatus') }}",
                        type: "POST",
                        data: _data
                    }).done(function(res) {
                        if(res.status == 'success'){
                            alert('success');
                            window.location = location.href;
                        }
                    });
                }
            })
        })
    </script>
@endpush
