@extends('layouts.color_admin.default')
@section('title', 'Moet Worden Bewerkt')
@push('css')
@endpush
@section('content')
    <div class="a-page-content">
        <div class="normal-table-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="normal-table-list xdev-table">
                            <div class="basic-tb-hd a-header-content">
                                <h2>Overeenkomst afvalbeheerbijdrage</h2>
                                <p>totaal: {{ count($items) }}</p>
                            </div>
                            <div class="table-responsive">
                                <table id="data-table" class="table table-sc-ex">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>OAV Nummer</th>
                                        <th>Bedrijfsnaam</th>
                                        <th>E-mail</th>
                                        <th>Adres</th>
										<td>Ingediend op</td>
                                        <th></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($items as $key => $item)
                                        <?php $date_show = $item->created_at ? date("d/m/Y H:i:s",strtotime($item->created_at)) : '';  ?>
                                        <tr>
                                            <td>{{ $key + 1  }}</td>
                                            <td>{{ $item->user->oav_number }}</td>
                                            <td>{{ $item->user->company_name }}</td>
                                            <td>{{ $item->user->email }}</td>
                                            <td>{{ $item->user->address }}</td>
											<td>{{$date_show}}</td>
                                            <td>
                                                <a href="{{ route('admin.recycling_contributions.download', ['id' => $item->user_id]) }}" class="btn btn-sm btn-primary">Detail</a>
                                            </td>
                                        </tr>
                                        @empty
                                            <tr>
                                                <td colspan="5" class="text-center">Geen data.</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
    $(function () {
        $("#data-table").DataTable({
            'paging': true,
            "pagingType": "simple_numbers",
            'lengthChange': true,
            'searching': true,
            'info': true,
            'autoWidth': false,
            'stateSave': true,
            "language": {
                "decimal":        "",
                "emptyTable":     "Geen data beschikbaar in de tabel",
                "info":           "Toon _START_ tot _END_ van _TOTAL_ items",
                "infoEmpty":      "Toon 0 van 0 van 0 items",
                "infoFiltered":   "(gefilterd uit _MAX_ totaal inzendingen)",
                "infoPostFix":    "",
                "thousands":      ",",
                "lengthMenu":     "Toon _MENU_ items",
                "loadingRecords": "Bezig met laden...",
                "processing":     "Verwerken...",
                "search":         "Zoeken:",
                "zeroRecords":    "Geen overeenkomende records gevonden",
                "paginate": {
                    "first":      "Eerste",
                    "last":       "Laatste",
                    "next":       "Volgende",
                    "previous":   "Vorige"
                },
                "aria": {
                    "sortAscending":  ": activeren om kolom oplopend te sorteren",
                    "sortDescending": ": activeren om kolom aflopend te sorteren"
                }
            }
        });
    });
</script>
@endpush
