@extends('layouts.app')

@section('content')

    <form id="b-card-body-content">
        <div class="row">
            <div class="col-12">
                <h1 class="title-page">Mijn Gegevens</h1>
            </div>
        </div>
        <div class="row mt-3" id="success-block" style="display:none">
            <div class="col-12">
                <div class="alert alert-success">
                    Verzonden
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <p>
                    Welkom op de vernieuwde website voor oavaangifte.nl. Voordat u verder kunt, verzoeken wij u om onderstaande gegevens te controleren. Zijn deze correct dan hoeft u niets te doen. Zijn deze gegevens niet correct, dan kunt u ze hieronder wijzigen.
                </p>
				@if( true )
                <a href="{{ route('recycling_contributions.download') }}">Overeenkomst voor de recyclingbijdrage</a>
				@endif
            </div>
        </div>
        {{-- <div class="row mt-4">
            <div class="col-md-3 col-12">
                <p>Bedrijfsnaam</p>
            </div>
            <div class="col-md-6 col-12">
                <input type="text" value="{{ $user->user_name }}" class="form-control" disabled />
            </div>
        </div> --}}
        <div class="row mt-2">
            <div class="col-md-3 col-12">
                <p>OAV E-mailadres</p>
            </div>
            <div class="col-md-6 col-12">
                <input type="text" value="{{ $user->email }}" name="email" class="form-control" />
            </div>
        </div>
        <div class="row mt-2">
            <div class="col-md-3 col-12">
                <p>Login-oavnummer</p>
            </div>
            <div class="col-md-6 col-12">
                <input type="text" value="{{ $user->oav_number }}" class="form-control" disabled />
            </div>
        </div>
        <div class="row mt-2">
            <div class="col-md-3 col-12">
                <p>Bedrijfsnaam</p>
            </div>
            <div class="col-md-6 col-12">
                <input type="text" value="{{ $user->company_name }}" name="company_name" class="form-control can-change" />
            </div>
        </div>
		<div class="row mt-2">
            <div class="col-md-3 col-12">
                <p>Contactpersoon</p>
            </div>
            <div class="col-md-6 col-12">
                <input type="text" value="{{ $user->contact_persoon }}" name="contact_persoon" class="form-control can-change" />
            </div>
        </div>
        <div class="row mt-2">
            <div class="col-md-3 col-12">
                <p>Adres</p>
            </div>
            <div class="col-md-6 col-12">
                <input type="text" value="{{ $user->address }}" name="address" class="form-control can-change" />
            </div>
        </div>
        <div class="row mt-2">
            <div class="col-md-3 col-12">
                <p>Postcode</p>
            </div>
            <div class="col-md-6 col-12">
                <input type="text" value="{{ $user->postcode }}" name="postcode" class="form-control can-change" />
            </div>
        </div>
        <div class="row mt-2">
            <div class="col-md-3 col-12">
                <p>Plaats</p>
            </div>
            <div class="col-md-6 col-12">
                <input type="text" value="{{ $user->place }}" name="place" class="form-control can-change" />
            </div>
        </div>
        <div class="row mt-2">
            <div class="col-md-3 col-12">
                <p>Land</p>
            </div>
            <div class="col-md-6 col-12">
                <!--<input type="text" value="{{ $user->land }}" name="land" class="form-control can-change" />-->
				<select name="land" class="form-control can-change">
					<option value="NL" <?php echo $user->land == "NL"? 'selected' : '' ?>>NL</option>
					<option value="BE" <?php echo $user->land == "BE"? 'selected' : '' ?>>BE</option>
					<option value="DE" <?php echo $user->land == "DE"? 'selected' : '' ?>>DE</option>
					<option value="HU" <?php echo $user->land == "HU"? 'selected' : '' ?>>HU</option>
				</select>
            </div>
        </div>
        <div class="row mt-2">
            <div class="col-md-3 col-12">
                <p>Telefoon</p>
            </div>
            <div class="col-md-6 col-12">
                <input type="text" value="{{ $user->phone }}" name="phone" class="form-control can-change" />
            </div>
        </div>
        <div class="row mt-2">
            <div class="col-md-3 col-12">
                <p>Fax</p>
            </div>
            <div class="col-md-6 col-12">
                <input type="text" value="{{ $user->fax }}" name="fax" class="form-control can-change" />
            </div>
        </div>
        <div class="row mt-2">
            <div class="col-md-3 col-12">
                <p>KvK nummer</p>
            </div>
            <div class="col-md-6 col-12">
                <input type="text" value="{{ $user->kvk_number }}" name="kvk_number" class="form-control can-change" />
            </div>
        </div>
        <div class="row mt-2">
            <div class="col-md-3 col-12">
                <p>BTW nummer</p>
            </div>
            <div class="col-md-6 col-12">
                <input type="text" value="{{ $user->btw_number }}" name="btw_number" class="form-control can-change" />
            </div>
        </div>
        <div class="row mt-4">
            <div class="col-12">
                <span class="btn btn-primary btn-sm" id="send-request">Verzend verzoek</span>
            </div>
        </div>
    </form>
@endsection

@section('js')
    <script>
        $(function () {
            let _page = $('#b-card-body-content');

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $(".input-date").datepicker({
                dateFormat: "yy-mm-dd"
            });

            _page.on('click', '#send-request', function () {
                //let _confirm = confirm('Weet je het zeker?');
                //if(_confirm){
                    $.ajax({
                        url: "{{ route('home.pru') }}",
                        data: $('#b-card-body-content').serializeArray(),
                        type: 'post',
                        success: function(res){
                            if(res.status == "success"){
                                $("#success-block").show();
                                $("html, body").animate({ scrollTop: 0 }, "slow");
                            }
                        }
                    });
                //}
            })
        })
    </script>
@endsection













