<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }}</title>
    <link href="/favicon.ico" rel="icon">
    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">

    <!-- Styles -->
    <link href="{{ asset('css/app.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <link rel="stylesheet" href="/admin_asset/css/bootstrap.min.css">
    <link href="{{ asset('css/style.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="/admin_asset/xdev_custom.css">
    <style>
    .js-cookie-consent{
        color: #fff!important;
        background-color: #3490dc;
        text-align:center;
        padding:10px;
    }
    .cookie-consent__agree{
        color:black;
    }
    .ml-auto .nav-item.underline{
        text-decoration: underline;
    }
    .ml-auto .nav-item:hover{
        text-decoration: underline;
    }
    .inline-item{
        display:inline-block;
    }
    .inline-item > a{
        color:white;
        margin-left:10px;
    }
	.btn-info{
		color: #3490dc;
		border-color: #3490dc;
		background-color:transparent;
	}
	
    </style>
</head>
<?php 
    $act = Route::getCurrentRoute()->getAction();  
    $routeName = Route::getCurrentRoute()->getName(); 
 ?>
<body id="<?php echo $routeName;?>">
@include('cookieConsent::index')
<div class="container" id="app">
    @if(session()->has('fromAdmin'))
        <div class="return-admin">
            <a href="{{ route('login.backAdmin', ['code' => session()->get('fromAdmin')]) }}" class="btn btn-sm btn-info">Terug naar backend</a>
        </div>
    @endif
    <div class="card" id="card-container">
        <div class="card-header">
            <div class="row">
                <div class="col-8">
                    <img src="/images/OAV_logo.png">
                </div>
                <div class="col-4 text-right" style="padding-right: 30px">
                    @if (Auth::check())
                        <a href="{{ route('logout') }}" class="btn btn-outline-danger btn-logout">Uitloggen</a>
                    @endif
                </div>
            </div>
            <div class="b-menu-bar">
                <nav class="navbar navbar-expand-md navbar-light bg-white shadow-sm">
                    @if (Auth::check())
                        <div class="container">
                            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="{{ __('Toggle navigation') }}">
                                <div class="b-menu-sm-icon"></div>
                                <div class="b-menu-sm-icon"></div>
                                <div class="b-menu-sm-icon"></div>
                            </button>
                            <?php $currentPath = Route::getFacadeRoot()->current()->uri(); ?>
                            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                                <ul class="navbar-nav ml-auto">
                                    @forelse($menu as $item)
                                        @if($item->status == \App\Models\Menu::STATUS_SHOW)
                                            <?php 
                                                $classUnderLine = "";
                                                if($currentPath === "/" && $item->url == "/"){
                                                    $classUnderLine = "underline";
                                                }else{
                                                    $action = str_replace("/","",$item->url);
                                                    if($action === $currentPath){
                                                        $classUnderLine = "underline";
                                                    }
                                                }
                                            ?>
                                            <li class="nav-item dropdown <?php echo $classUnderLine; ?>">
                                                <a href="{{ $item->url }}">{{ $item->display }}</a>
                                            </li>
                                        @endif
                                    @empty
                                    @endforelse
                                </ul>
                            </div>
                        </div>
                    @endif
                </nav>
            </div>
        </div>
        <div class="card-body">
            @yield('content')
            
        </div>
        <div class="card-footer">
            <div class="b-footer-content">
                © Onafhankelijke Administratie Vlakglas (OAV)
                <ul style="display:inline-block">
                    <li class="inline-item"><a href="{{route('privacy')}}" title="Privacystatement">Privacystatement</a></li>
                    <li class="inline-item"><a href="{{route('cookies')}}" title="Cookiestatement">Cookiestatement</a></li>
                    <li class="inline-item"><a href="{{route('disclaimer')}}" title="Disclaimer">Disclaimer</a></li>
                </ul>
            </div>
        </div>
    </div>
</div>
<script src="{{ asset('/js/jquery.min.js') }}"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
@yield('js')
</body>
</html>
