<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
	@include('includes.head')
</head>
@php
	$bodyClass = (!empty($boxedLayout)) ? 'boxed-layout' : '';
	$bodyClass .= (!empty($paceTop)) ? 'pace-top ' : '';
	$bodyClass .= (!empty($bodyExtraClass)) ? $bodyExtraClass . ' ' : '';
	$sidebarHide = (!empty($sidebarHide)) ? $sidebarHide : '';
	$sidebarTwo = (!empty($sidebarTwo)) ? $sidebarTwo : '';
	$topMenu = (!empty($topMenu)) ? $topMenu : '';
	$footer = (!empty($footer)) ? $footer : '';
	
	$pageContainerClass = (!empty($topMenu)) ? 'page-with-top-menu ' : '';
	$pageContainerClass .= (!empty($sidebarRight)) ? 'page-with-right-sidebar ' : '';
	$pageContainerClass .= (!empty($sidebarLight)) ? 'page-with-light-sidebar ' : '';
	$pageContainerClass .= (!empty($sidebarWide)) ? 'page-with-wide-sidebar ' : '';
	$pageContainerClass .= (!empty($sidebarHide)) ? 'page-without-sidebar ' : '';
	$pageContainerClass .= (!empty($sidebarMinified)) ? 'page-sidebar-minified ' : '';
	$pageContainerClass .= (!empty($sidebarTwo)) ? 'page-with-two-sidebar ' : '';
	$pageContainerClass .= (!empty($contentFullHeight)) ? 'page-content-full-height ' : '';
	
	$contentClass = (!empty($contentFullWidth) || !empty($contentFullHeight)) ? 'content-full-width ' : '';
	$contentClass .= (!empty($contentInverseMode)) ? 'content-inverse-mode ' : '';
@endphp
<?php 
    $act = Route::getCurrentRoute()->getAction();  
    $routeName = Route::getCurrentRoute()->getName(); 
 ?>
<body class="{{ $bodyClass }}" id="<?php echo $routeName;?>">
	<style>
	@media (min-width: 1200px){
		.container {
			max-width: 100% !important;
		}
	}
	</style>
	@include('includes.component.page-loader')
	
	<div id="page-container" class="page-container fade page-sidebar-fixed page-header-fixed {{ $pageContainerClass }}">
		
		@include('includes.header')
		
		@includeWhen($topMenu, 'includes.top-menu')
		
		@includeWhen(!$sidebarHide, 'includes.sidebar')
		
		@includeWhen($sidebarTwo, 'includes.sidebar-right')
		
		<div id="content" class="content {{ $contentClass }} print-area">
			<div class="panel panel-inverse">
				<div class="panel-body">
					@yield('content')
				</div>
			</div>
		</div>
		
		@includeWhen($footer, 'includes.footer')
		
		@include('includes.component.theme-panel')
		
		@include('includes.component.scroll-top-btn')
		
	</div>
	<div class="ajax-loading">
		<i class="fa fa-spinner fa-pulse fa-3x"></i>
	</div>
	@include('includes.page-js')
</body>
</html>
