<?php
use App\Http\Controllers\RecyclingContributionController;
use App\Http\Controllers\Admin\RecyclingContributionController as AdminRecyclingContributionController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('login', 'Auth\LoginController@showLoginForm')->name('login');
Route::post('login', 'Auth\LoginController@login')->name('post_login');
Route::get('logout', 'Auth\LoginController@logout')->name('logout');

Route::get('/privacy', 'HomeController@renderPrivacy')->name('privacy');
Route::get('/cookies', 'HomeController@renderCookies')->name('cookies');
Route::get('/disclaimer', 'HomeController@renderDisclaimer')->name('disclaimer');

Route::get('forgot', 'Auth\LoginController@forgot')->name('forgot');
Route::get('recovery', 'Auth\LoginController@recovery')->name('recovery');
Route::get('newPassword/{code}', 'Auth\LoginController@newPassword')->name('newPassword');
Route::post('changePass', 'Auth\LoginController@changePass')->name('changePass');
Route::post('finishChange', 'Auth\LoginController@finishChange')->name('finishChange');

Route::get('/', 'HomeController@index')->name('home.index');
Route::get('/bg', 'HomeController@bg')->name('home.bg');
Route::get('/ma', 'HomeController@ma')->name('home.ma');
Route::get('/cma/{id}', 'HomeController@cma')->where('id', '[0-9]+')->name('home.cma');
Route::get('/credit-memo/{id}/{year}', 'HomeController@showCreditMemo')->where('id', '[0-9]+')->where('year', '[0-9]+')->name('home.credit.memo');
Route::post('/pma', 'HomeController@pma')->name('home.pma');
Route::get('/contact', 'HomeController@contact')->name('home.contact');
Route::post('/postContact', 'HomeController@postContact')->name('home.postContact');
Route::get('/mg', 'HomeController@mg')->name('home.mg');
Route::get('/qa', 'HomeController@qa')->name('home.qa');
Route::post('/pru', 'HomeController@pru')->name('home.pru');
Route::get('/pdfma/{id}', 'PrintController@createDomPdf')->where('id', '[0-9]+')->name('pdf.pdfma');
Route::get('/printCertification/{id}/{next_period}', 'PrintController@printCertification')->where('id', '[0-9]+')->where('next_period', '[0-9]+')->name('pdf.printCertification');
Route::get('/print-total/{id}/{year}', 'PrintController@createCreditMemoPdf')->where('id', '[0-9]+')->where('year', '[0-9]+')->name('pdf.total');
Route::get('/print-q-6/{id}/{year}', 'PrintController@createQuarterSix')->where('id', '[0-9]+')->where('year', '[0-9]+')->name('pdf.q_six');
Route::post('/agree-q-6', 'HomeController@agreeCreditMemo')->name('home.agree-credit-memo');

Route::namespace('Admin')->prefix('admin')->name('admin.')->group(function () {
    Route::get('login', 'AuthController@showLoginForm')->name('showLoginForm');
    Route::post('login', 'AuthController@login')->name('login');
    Route::get('logout', 'AuthController@logout')->name('logout');
    Route::post('forgotPassword', 'AuthController@forgotPassword')->name('forgotPassword');
    Route::get('password/{code}', 'AuthController@showPasswordForm')->name('password');
    Route::post('changePassword', 'AuthController@changePassword')->name('changePassword');
    Route::group(
        [
            'middleware' => 'admin:admin',
        ],
        function () {
            Route::get('/dashboard', 'DashboardController@index')->name('dashboard.index');
            Route::get('/', 'HomeController@index')->name('home.index');
            Route::get('/ajaxGetUser', 'HomeController@ajaxGetUser')->name('home.ajaxGetUser');
            Route::get('/ajaxGetUserAssign', 'PeriodController@getListUserForAssignToPeriod')->name('home.getListUserForAssignToPeriod');
            Route::get('/ajaxGetUserNotDeclarationOfPeriod', 'PeriodController@ajaxGetUserNotDeclatationOfPeriod')->name('home.ajaxGetUserNotDeclatationOfPeriod');
            Route::get('/detail/{id}', 'HomeController@detail')->where('id', '[0-9]+')->name('home.detail');
            Route::get('/request-edit', 'HomeController@requestEdit')->name('home.requestEdit');
            Route::get('/viewRequest/{id}', 'HomeController@viewRequest')->where('id', '[0-9]+')->name('home.viewRequest');
            Route::post('/store', 'HomeController@store')->name('home.store');
            Route::post('/changeActive', 'HomeController@changeActive')->name('home.changeActive');

            Route::get('/manager', 'AdminController@index')->name('admin.index');
            Route::get('/manager/update/{id}', 'AdminController@update')->where('id', '[0-9]+')->name('admin.update');
            Route::post('/manager/store', 'AdminController@store')->name('admin.store');
            Route::post('/manager/delete', 'AdminController@delete')->name('admin.delete');

            Route::post('/import', 'AdminController@importUser')->name('admin.import');

            Route::get('/exporteren', 'ExporterenController@index')->name('dec.exporteren');
            Route::post('/exporteren-download', 'ExporterenController@export')->name('dec.exporterendownload');

            Route::get('/maList', 'DeclarationController@maList')->name('dec.maList');
            Route::post('/get-maList', 'DeclarationController@getMaList')->name('dec.getMaList');
            Route::get('/readPdf/{id}/{user_id}', 'DeclarationController@createdf')->where('id', '[0-9]+')->where('user_id', '[0-9]+')->name('dec.readpdf');
            Route::get('/maListNone', 'DeclarationController@maListNone')->name('dec.maListNone');
            Route::get('/q6List', 'DeclarationController@q6List')->name('dec.maq6List');
            Route::get('/maDetail/{id}', 'DeclarationController@maDetail')->where('id', '[0-9]+')->name('dec.maDetail');
            Route::get('/sendEmailDetail/{id}', 'DeclarationController@sendEmailDetail')->where('id', '[0-9]+')->name('dec.sendEmailDetail');
            Route::get('/aTypeList', 'DeclarationController@aTypeList')->name('dec.aTypeList');
            Route::get('/update-user', 'ImportController@index')->name('user.update-user');
            Route::get('/run-update-user', 'ImportController@runUpdateUser')->name('user.run-update-user');
            Route::get('/updateDecType/{id}', 'DeclarationController@updateDecType')->where('id', '[0-9]+')->name('dec.updateDecType');
            Route::get('/deleteDecType/{id}', 'DeclarationController@deleteDecType')->where('id', '[0-9]+')->name('dec.deleteDecType');
            Route::post('/storeDecType', 'DeclarationController@storeDecType')->name('dec.storeDecType');
            Route::post('/updateDec', 'DeclarationController@updateDec')->name('dec.updateDec');
            Route::post('/deleteDec', 'DeclarationController@deleteDec')->name('dec.deleteDec');

            Route::get('/periodList', 'PeriodController@periodList')->name('period.periodList');
            Route::get('/updatePeriod/{id}', 'PeriodController@updatePeriod')->where('id', '[0-9]+')->name('period.updatePeriod');
            Route::post('/savePeriod', 'PeriodController@savePeriod')->name('period.savePeriod');
            Route::get('/emailPeriod/{id}', 'PeriodController@emailPeriod')->where('id', '[0-9]+')->name('period.emailPeriod');
            Route::post('/sendPeriod', 'PeriodController@sendPeriod')->name('period.sendPeriod');
            Route::post('/sendRemindPeriod', 'PeriodController@sendRemindPeriod')->name('period.sendRemindPeriod');
            // assign users to period
            Route::post('/emailPeriod/assignUser', 'PeriodController@assignUser')->name('period.assignUser');

            Route::get('loginAs', 'LoginAsController@index')->name('login.index');
            Route::post('loginAction', 'LoginAsController@loginAction')->name('login.loginAction');

            Route::get('mailTemplate', 'EmailController@mailTemplate')->name('email.mailTemplate');
            Route::get('mailDetail/{id}', 'EmailController@mailDetail')->where('id', '[0-9]+')->name('email.mailDetail');
            Route::post('saveMail', 'EmailController@saveMail')->name('email.saveMail');
            Route::get('previewMail/{id}', 'EmailController@previewMail')->where('id', '[0-9]+')->name('email.previewMail');

            Route::get('menu', 'MenuController@index')->name('menu.index');
            Route::get('qa', 'MenuController@qa')->name('menu.qa');
            Route::post('changeQA', 'MenuController@changeQA')->name('menu.changeQA');
            Route::post('changeStatus', 'MenuController@changeStatus')->name('menu.changeStatus');

            Route::get('recycling_contributions', [AdminRecyclingContributionController::class, 'index'])->name('recycling_contributions.index');
            Route::get('recycling-contributions/download/{id}', [AdminRecyclingContributionController::class, 'download'])->name('recycling_contributions.download');
        }
    );
});



Route::group(['middleware' => 'auth'], function () {
    Route::get('/backAdmin/{code}', 'Admin\LoginAsController@backAdmin')->name('login.backAdmin');
});

Route::get('/transfer/{code}', 'Admin\LoginAsController@transfer')->name('login.transfer');
Route::get('/transferAd/{code}', 'Admin\LoginAsController@transferAd')->name('login.transferAd');

Route::get('/fix-double-entry', 'ToolController@index');

Route::get('/recycling-contributions/create', [RecyclingContributionController::class, 'create'])->name('recycling_contributions.create');
Route::post('/recycling-contributions/store', [RecyclingContributionController::class, 'store'])->name('recycling_contributions.store');
Route::get('/recycling-contributions/download/{user_id?}', [RecyclingContributionController::class, 'download'])->name('recycling_contributions.download');

